<?php
/**
 * An item returned from a folder list.
 *
 * $Horde: horde/lib/VFS/ListItem.php,v 1.7 2003/08/22 00:05:19 chuck Exp $
 *
 * Copyright 2002-2003 Jon Wood <jon@jellybob.co.uk>
 *
 * See the enclosed file COPYING for license information (LGPL). If you
 * did not receive this file, see http://www.fsf.org/copyleft/lgpl.html.
 *
 * @author  Jon Wood <jon@jellybob.co.uk>
 * @version $Revision: 1.7 $
 * @package vfs
 * @since   Horde 2.2
 */
class VFS_ListItem {

    /**
     * VFS path
     *
     * @var $path string
     */
    var $_path;

    /**
     * Filename
     *
     * @var $name string
     */
    var $_name;

    /**
     * File permissions (*nix format: drwxrwxrwx)
     *
     * @var $perms string
     */
    var $_perms;

    /**
     * Owner user
     *
     * @var $owner string
     */
    var $_owner;

    /**
     * Owner group
     *
     * @var $group string
     */
    var $_group;

    /**
     * Size
     *
     * @var $size string
     */
    var $_size;

    /**
     * Last modified date
     *
     * @var $date string
     */
    var $_date;

    /**
     * Type
     * .*: File extension
     * **none: Unrecognised type
     * **sym: Symlink
     * **dir: Directory
     *
     * @var $type string
     */
    var $_type;

    /**
     * Type of target if type is '**sym'
     * NB. Not all backends are capable of distinguishing all of these
     * .*: File extension
     * **none: Unrecognised type
     * **sym: Symlink to a symlink
     * **dir: Directory
     * **broken: Target not found - broken link
     *
     * @var $linktype string
     */
    var $_linktype;

    /**
     * Constructor
     * Requires the path to the file, and it's array of properties, returned from a standard
     * VFS::listFolder() call.
     *
     * @param string $path      The path to the file.
     * @param array  $fileArray An array of file properties.
     */
    function VFS_ListItem($path, $fileArray)
    {
        $this->_path = $path . '/' . $fileArray['name'];
        $this->_name = $fileArray['name'];
        $this->_dirname = $path;
        $this->_perms = $fileArray['perms'];
        $this->_owner = $fileArray['owner'];
        $this->_group = $fileArray['group'];
        $this->_size = $fileArray['size'];
        $this->_date = $fileArray['date'];
        $this->_type = $fileArray['type'];
        $this->_linktype = $fileArray['linktype'];
    }

}
