<?php

require_once dirname(__FILE__) . '/../Text.php';

/**
 * The Text_emoticons:: class.
 *
 * $Horde: horde/lib/Text/Filter/emoticons.php,v 1.1 2003/08/21 21:12:48 chuck Exp $
 *
 * Copyright 2003 Marko Djukic <marko@oblo.com>
 *
 * See the enclosed file COPYING for license information (LGPL). If you did not
 * receive this file, see http://www.fsf.org/copyleft/lgpl.html.
 *
 * @author  Marko Djukic <marko@oblo.com>
 * @version $Revision: 1.1 $
 * @package horde
 */
class Text_emoticons extends Text {

    /**
     * Convert textual emoticons into graphical ones.
     *
     * @access public
     *
     * @param string $text  The text to filter.
     *
     * @return string  The text with any graphical emoticons inserted.
     */
    function convertEmoticons($text)
    {
        $emoticons = Text_emoticons::availableEmoticons();

        /* Loop through possible string emoticons and convert to graphics. */
        foreach ($emoticons as $string => $icon) {
            $text = str_replace($string, Horde::img($icon . '.gif', '', 'align="middle"', $GLOBALS['registry']->getParam('graphics', 'horde') . '/emoticons'), $text);
        }

        return $text;
    }

    function availableEmoticons()
    {
        /* List complex strings before simpler ones, otherwise for example
           :(( would be matched against :( before :(( is found. */
        $icons = array(
            ':/' => 'frustrated', ':-/' => 'frustrated', ':*>' => 'blush',
            ':e' => 'disappointed', '=:)$' => 'mrt', '#|' => 'hangover',
            '#-|' => 'hangover', ':-@' => 'shout', ':((' => 'bigfrown',
            ':C' => 'bigfrown', ':S' => 'dazed', ':-S' => 'dazed',
            'X@' => 'angry', 'X(' => 'mad', '>:)' => 'devil', '>:-)' => 'devil',
            '>:p' => 'deviltongue', '>:-p' => 'deviltongue',
            '>:p' => 'raspberry', '>:P' => 'raspberry', '&)' => 'punk',
            '&p' => 'punktongue', '=&)' => 'punkmohawk', ':]' => 'grin',
            '#[' => 'hurt', '#(' => 'hurt', '#-[' => 'hurt', '#-(' => 'hurt',
            ':O' => 'embarrassed', ':-O' => 'embarrassed', ':[' => 'sad',
            '>:@' => 'enraged', ':&' => 'annoyed', '=(' => 'worried',
            '=-(' => 'worried', ':|=' => 'vampire', ':-(' => 'frown',
            ':D' => 'biggrin', '8)' => 'cool', '8p' => 'cooltongue',
            '8' => 'cooltongue', '8D' => 'coolgrin', ':p' => 'tongueout',
            ':P' => 'tongueout', ':' => 'tongueout', '?:(' => 'confused',
            '%-(' => 'confused', ':)&' => 'love', ';-)' => 'wink',
            ';]' => 'winkgrin', ';p' => 'winktongue', ';P' => 'winktongue',
            ';' => 'winktongue', ':|' => 'indifferent', ':-|' => 'indifferent',
            '!|' => 'tired', '!-I' => 'tired', '|I' => 'asleep',
            '|-I' => 'asleep', 'O:)' => 'angel', 'O:-)' => 'angel',
            'O;)' => 'angelwink', 'O;-)' => 'angelwink', ':#)' => 'clown',
            ':o)' => 'clown', ':)' => 'smile', ';)' => 'wink', ':-)' => 'smile',
            ':@' => 'shout', ':(' => 'frown');

        return $icons;
    }

}
