<?php
/**
 * The MIME_Viewer_php class renders out syntax-highlighted PHP
 * code in HTML format.
 *
 * $Horde: horde/lib/MIME/Viewer/php.php,v 1.15 2003/01/19 21:23:05 slusarz Exp $
 *
 * Copyright 1999-2003 Chuck Hagenbuch <chuck@horde.org>
 *
 * See the enclosed file COPYING for license information (LGPL). If you
 * did not receive this file, see http://www.fsf.org/copyleft/lgpl.html.
 *
 * @author  Chuck Hagenbuch <chuck@horde.org>
 * @version $Revision: 1.15 $
 * @since   Horde 1.3
 * @package horde.mime.viewer
 */
class MIME_Viewer_php extends MIME_Viewer {

    /**
     * Renders out the contents.
     *
     * @access public
     *
     * @param optional array $params  Any parameters the Viewer may need.
     *
     * @return string  The rendered contents.
     */
    function render($params = array())
    {
        return Horde::bufferOutput('highlight_string', $this->mime_part->getContents());
    }

    /**
     * Return the MIME content type of the rendered content.
     *
     * @access public
     *
     * @return string  The content type of the output. 
     */
    function getType()
    {
        return 'text/html';
    }

}
