<?php
/**
 * Utility Class for the IE Designmode Editor.
 *
 * $Horde: horde/lib/Editor.php,v 1.2 2003/01/03 02:32:26 jan Exp $
 *
 * Copyright 2002-2003 stroh@scan-plus.de
 *
 * See the enclosed file COPYING for license information (LGPL). If you
 * did not receive this file, see http://www.fsf.org/copyleft/lgpl.html.
 *
 * @author  stroh@scan-plus.de
 * @version $Revision: 1.2 $
 * @since   Horde 3.0
 * @package horde
 */
class Horde_Editor {

    var $_height = 18;
    var $_width = 18;
    var $_align = 'absMiddle';

    /**
     * @return an <img.. /> tag for control button
     */
    function drawButton($src, $alt = '', $id = null, $js_onClick = null, 
                        $js_onDown = null, $js_onOver = null)
    {
        global $registry;

        $attrs = sprintf('width="%d" height="%d" align="%s" %s%s%s%s', 
                         $this->_width, $this->_height, $this->_align,
                         !is_null($id) ? ' id="' . $id . '" ' : '',
                         !is_null($js_onClick) ? ' onClick="'.$js_onClick . '" ' : '',
                         !is_null($js_onDown) ? ' onMouseDown="' . $js_onDown . '" ' : '',
                         !is_null($js_onOver) ? ' onMouseOver="' . $js_onOver . '" ' : '');
        return Horde::img($src, $alt, $attrs, $registry->getParam('graphics', 'horde') . '/editor');
    }

    /**
     * @return an <img.../> tag for separator
     */
    function insertSeparator()
    {
        global $registry;

        $img = Horde::img('spacer.gif', '', ' width="2" class="spacer" ', $registry->getParam('graphics', 'horde') . '/editor');
        return $img . '<span class="sep"></span>';
    }

}
