<?php
/**
 * Horde_Scheduler_kronolith:: Act on alarms in events and send
 * emails/pages/etc. to users.
 *
 * $Horde: kronolith/lib/Scheduler/kronolith.php,v 1.6 2003/05/22 16:57:01 chuck Exp $
 *
 * @package horde.scheduler
 */
class Horde_Scheduler_kronolith extends Horde_Scheduler {

    var $_shares;
    var $_driver;
    var $_seen = array();
    var $_calendars = array();

    function Horde_Scheduler_kronolith($params)
    {
        parent::Horde_Scheduler($params);

        $this->_shares = $params['shares'];
        $this->_driver = $params['driver'];
        $this->_calendars = $this->_shares->listAllShares();
    }

    function run()
    {
        if (!count($this->_calendars)) {
            exit("eventd: No calendars to monitor; exiting.\n");
        }

        while (true) {
            $t = time();
            $ts = date('Hi', $t);

            // Check for alarms and act on them.
            $alarms = Kronolith::listAlarms(Kronolith::timestampToObject($t), array_keys($this->_calendars));

            foreach ($alarms as $cal => $calarms) {
                foreach ($calarms as $eventid) {
                    $seenid = date('Ymd') . $eventid;
                    if (!isset($this->_seen[$seenid])) {
                        $this->_seen[$seenid] = true;
                        $this->remind($cal, $eventid);
                    }
                }
            }

            // Wait until the next minute.
            while (date('Hi') == $ts) {
                $this->sleep(2000000);
            }
        }
    }

    function remind($calendar, $eventid)
    {
        if ($this->_driver->getCalendar() != $calendar) {
            $this->_driver->open($calendar);
        }
        $event = &$this->_driver->getEventObject($eventid);

        // Check for exceptions; do nothing is one is found.
        if ($event->hasException(date('Y'), date('n'), date('j'))) {
            return;
        }

        global $conf;
        static $emails;
        if (empty($emails)) {
            $emails = array();
        }

        require_once HORDE_BASE . '/lib/Text.php';
        require_once HORDE_BASE . '/lib/MIME.php';
        require_once HORDE_BASE . '/lib/MIME/Headers.php';
        require_once HORDE_BASE . '/lib/MIME/Message.php';

        if (empty($emails[$calendar])) {
            $identity = &$this->_shares->getIdentityByShare($calendar);
            $email = $identity->getValue('from_addr');
            list($mailbox, $host) = explode('@', $email);
            $emails[$calendar] = MIME::rfc822WriteAddress($mailbox, $host, $identity->getValue('fullname'));
        }

        $msg_headers = &new MIME_Headers();
        $msg_headers->addMessageIdHeader();
        $msg_headers->addAgentHeader();
        $msg_headers->addHeader('Date', date('r'));
        $msg_headers->addHeader('To', $emails[$calendar]);
        $msg_headers->addHeader('From', $emails[$calendar]);
        $msg_headers->addHeader('Subject', sprintf(_("Reminder: %s"), $event->title));

        $recipients = $emails[$calendar];

        $message = "\n" . sprintf(_("You requested to be reminded about %s, which is at %s."), $event->title, strftime('%X', $event->getStartTimestamp())) . "\n\n" . $event->getDescription();

        $mime = &new MIME_Message();
        $body = &new MIME_Part('text/plain', Text::wrap($message, 76, "\n"));

        $mime->addPart($body);
        $msg_headers->addMIMEHeaders($mime);
        return $mime->send($recipients, $msg_headers);
    }

}
