<?php
/**
 * $Horde: kronolith/addeventaction.php,v 1.40 2003/05/22 18:23:26 chuck Exp $
 *
 * Copyright 1999, 2000 Charles J. Hagenbuch <chuck@horde.org>
 *
 * See the enclosed file COPYING for license information (GPL).  If you
 * did not receive this file, see http://www.fsf.org/copyleft/gpl.html.
 */

define('KRONOLITH_BASE', dirname(__FILE__));
require_once KRONOLITH_BASE . '/lib/base.php';

if (!Horde::getFormData('cancel')) {
    $calendar_id = Horde::getFormData('targetcalendar', $prefs->getValue('default_share'));
    $share = &$shares->getShare($calendar_id);
    if (is_a($share, 'PEAR_Error')) {
        $notification->push(sprintf(_("There was an error accessing the calendar: %s"), $share->getMessage()), 'horde.error');
    } elseif (!$share->hasPermission(Auth::getAuth(), _PERMS_EDIT, Auth::getAuth())) {
        $notification->push(sprintf(_("You do not have permission to add events to %s."), $share->getShareName()), 'horde.warning');
    } else {
        $calendar->open($calendar_id);
        $event = &$calendar->getEventObject();
        $event->readForm();
        $res = $event->save();
        if (is_a($res, 'PEAR_Error')) {
            $notification->push(sprintf(_("There was an error adding the event: %s"), $res->getMessage()), 'horde.error');
        }
    }
}

if ($url = Horde::getFormData('url')) {
    header('Location: ' . Horde::applicationUrl($url, true));
} else {
    $url = Horde::addParameter($prefs->getValue('defaultview') . '.php', 'month', Horde::getFormData('month'));
    $url = Horde::addParameter($url, 'year', Horde::getFormData('year'));
    header('Location: ' . Horde::applicationUrl($url, true));
}
