<?php
/**
 * This script displays a rendered MIME_Part object.
 * The following are potential URL parameters that we should honor:
 *   'actionID' -- The action ID to perform
 *     -> 'download_all'
 *     -> 'download_attach'
 *     -> 'download_render'
 *     -> 'save_message'
 *     -> 'view_attach'
 *     -> 'view_source'
 *   'ctype'    -- The content-type to use instead of the content-type
 *                 found in the original MIME_Part object
 *   'id'       -- The MIME part to display
 *   'index'    -- The index of the message; only used for IMP_Contents
 *                 objects
 *   'zip'      -- Download in .zip format?
 *
 * $Horde: imp/view.php,v 2.173 2003/08/05 23:13:51 jan Exp $
 *
 * Copyright 1999-2003 Charles J. Hagenbuch <chuck@horde.org>
 * Copyright 1999-2003 Jon Parise <jon@horde.org>
 * Copyright 2002-2003 Michael Slusarz <slusarz@bigworm.colorado.edu>
 *
 * See the enclosed file COPYING for license information (GPL).  If you
 * did not receive this file, see http://www.fsf.org/copyleft/gpl.html.
 */

define('IMP_BASE', dirname(__FILE__));
require_once IMP_BASE . '/lib/base.php';
require_once IMP_BASE . '/lib/Contents.php';

$actionID = Horde::getFormData('actionID');
$id = Horde::getFormData('id');
$index = Horde::getFormData('index');

/* Get cached item, if available. */
if (!($contents = &IMP_Contents::getCache())) {
    $contents = &new IMP_Contents($index);
}

if (($actionID != 'download_all') &&
    ($actionID != 'save_message') &&
    ($actionID != 'view_source')) {
    $mime = $contents->getDecodedMIMEPart($id);
    if (($ctype = Horde::getFormData('ctype'))) {
        $mime->setType($ctype);
    }
}

/* Run through action handlers */
switch ($actionID) {
case 'download_all':
    $tosave = array();
    foreach ($contents->getDownloadAllList() as $val) {
        $mime = $contents->getDecodedMIMEPart($val);
        $tosave[] = array('data' => $mime->getContents(), 'name' => $mime->getName(true, true));
    }

    include_once HORDE_BASE . '/lib/Compress.php';
    $horde_compress = &Horde_Compress::singleton('zip');
    $body = $horde_compress->compress($tosave);
    $browser->downloadHeaders(_("attachments.zip"), 'application/zip', false, strlen($body));
    echo $body;
    exit;

case 'download_attach':
case 'download_render':
    switch ($actionID) {
    case 'download_attach':
        /* Make sure we get the entire contents of the part. */
        $mime = $contents->getDecodedMIMEPart($id, true);
        $body = $mime->getContents();
        break;

    case 'download_render':
        $body = $contents->renderMIMEPart($mime);
        break;
    }

    $name = $mime->getName(true, true);
    $type = $mime->getType();

    /* Compress output? */
    if (($actionID == 'download_attach') && Horde::getFormData('zip')) {
        include_once HORDE_BASE . '/lib/Compress.php';
        $horde_compress = &Horde_Compress::singleton('zip');
        $body = $horde_compress->compress(array(array('data' => $body, 'name' => $name)));
        $name .= '.zip';
        $type = 'applcation/zip';
    }
    $browser->downloadHeaders($name, $type, false, strlen($body));
    echo $body;
    exit;

case 'view_attach':
    $body = $contents->renderMIMEPart($mime);
    $type = $contents->getMIMEViewerType($mime);
    if ($mime->getPrimaryType() == 'text') {
        $type .= '; charset=' . NLS::getCharset();
    }
    $browser->downloadHeaders($mime->getName(true, true), $type, true, strlen($body));
    echo $body;
    exit;

case 'view_source':
    $msg = $contents->fullMessageText();
    $browser->downloadHeaders('Message Source', 'text/plain', true, strlen($msg));
    echo $msg;
    exit;

case 'save_message':
    require_once IMP_BASE . '/lib/Headers.php';
    $imp_headers = &new IMP_Headers($index);

    $name = 'save_message';
    if (($subject = $imp_headers->getOb('subject', true))) {
        $name = preg_replace('|\W|', '_', $subject);
    }

    /* The standard for saving RFC 822 messages appears to be appending .eml
       to the end of the file. */
    $name .= '.eml';

    if (!($from = $imp_headers->getFromAddress())) {
        $from = '<>';
    }
    $date  = strftime('%a %b %d %H:%M:%S %Y', $imp_headers->getOb('udate'));
    $body  = 'From ' . $from . ' ' . $date. "\n";
    $body .= $contents->fullMessageText();
    $body  = str_replace("\r\n", "\n", $body);

    $browser->downloadHeaders($name, null, false, strlen($body));
    echo $body;
    exit;
}
