<?php
/**
 * Implementation of the Quota API for Cyrus IMAP servers.
 *
 * $Horde: imp/lib/Quota/cyrus.php,v 1.15 2003/05/31 16:42:37 jan Exp $
 *
 * Copyright 2002-2003 Mike Cochrane <mike@graftonhall.co.nz>
 *
 * See the enclosed file COPYING for license information (GPL). If you
 * did not receive this file, see http://www.fsf.org/copyleft/gpl.html.
 *
 * @author  Mike Cochrane <mike@graftonhall.co.nz>
 * @version $Revision: 1.15 $
 * @since   IMP 4.0
 * @package imp.quota
 */
class IMP_Quota_cyrus extends IMP_Quota {

    /**
     * Constructor
     *
     * @access public
     *
     * @param optional array $params  Hash containing connection parameters.
     */
    function IMP_Quota_cyrus($params = array())
    {
        $this->_params = $params;

        if (!array_key_exists('login', $this->_params)) {
            $this->_params['login'] = '';
        }
        if (!array_key_exists('password', $this->_params)) {
            $this->_params['password'] = '';
        }

        /* Get the delimiter for the folder. */
        require_once IMP_BASE . '/lib/Folder.php';
        $imp_folder = &IMP_Folder::singleton();
        $this->_params['delimiter'] = $imp_folder->getDelimiter($_SESSION['imp']['stream']);
    }

    /**
     * Get quota HTML to push to user.
     *
     * @access public
     *
     * @return string  The HTML representation of the quota data.
     */
    function quotaHTML()
    {
        $mbox = 'user' . $this->_params['delimiter'] . $_SESSION['imp']['user'];

        $quota = null;

        if (function_exists('imap_get_quotaroot')) {
            @$quota = imap_get_quotaroot($_SESSION['imp']['stream'], $mbox);
        } else {
            $stream = @imap_open(IMP::serverString(), $this->_params['login'], $this->_params['password'], OP_HALFOPEN);
            if ($stream !== false) {
                $quota = @imap_get_quota($stream, $mbox);
                @imap_close($stream);
            }
        }
        if (is_array($quota)) {
            if (isset($quota['limit'])) {
                return $this->_quotaHTML($quota['usage'] * 1024, $quota['limit'] * 1024);
            } elseif (isset($quota['STORAGE']['limit'])) {
                return $this->_quotaHTML($quota['STORAGE']['usage'] * 1024, $quota['STORAGE']['limit'] * 1024);
            }
            return $this->_quotaHTML(0, 0);
        }

        return $this->_quotaError(_("Unable to retrieve quota"));
    }

}
