<?php
// Get the horde password so we can try to check for existing forwards
$hordePassword = Auth::getCredential('password');

// Check for existing forwards
if ($isForwarding = $driver->isEnabledForwarding($user, $realm, $hordePassword)) {
    $current_target = $driver->currentTarget($user, $realm, $hordePassword);
    $current_keeplocal = $driver->isKeepLocal($user, $realm, $hordePassword);
} else {
    $current_target = '';
    $current_keeplocal = '';
}
?>
<table class="light">
<tr>
    <td class="header">
        <?php echo _("Set or Remove E-Mail Forwards") ?>
    </td>
</tr>
<tr>
    <td>
        <?php echo _("An e-mail forward lets you redirect your mail to another address (or a comma separated list of addresses if you wish). You can even forward to another address and keep a copy in your local mailbox.") ?> &nbsp;
        <?php echo _("This form lets you install (or remove) e-mail forwarding for your account.") ?>
    </td>
</tr>
<tr>
    <td>
        <br />
        <form method="post" action="<?php echo Horde::applicationUrl('main.php') ?>" name="forwards">
        <?php echo Horde::formInput() ?>
        <input type="radio" name="mode" value="set" checked="checked">
        <?php echo _("Set/install a forward to:") ?>&nbsp;
        <input type="text" name="where" value="<?php echo $current_target ?>" size="63" maxlength="150">

        <blockquote>
            <input type="checkbox" name="metoo">
            <?php echo _("Keep a copy in your local mailbox?") ?>
        </blockquote>

        <input type="radio" name="mode" value="unset">
        <?php echo _("Unset/remove a forward") ?>

        <br /><br />
        <?php echo _("For your protection and safety, you must identify yourself with your login password to verify this change.") ?>&nbsp;
        <?php echo _("Then submit the form so that your forward can be updated.") ?>
        <br />
        <input type="hidden" name="userid" value="<?php echo Auth::getAuth() ?>">
        <?php echo _("Your password:") ?> &nbsp;
        <input type="password" name="oldpassword" size="16" maxlength="32">&nbsp;
        <input class="button" type="submit" name="submit" value="<?php echo _("Submit") ?>" onclick="return submit_form();">
        </form>
    </td>
</tr>
</table>
