/*
    This file is part of KOrganizer.
    Copyright (c) 2003 Bo Thorsen  <bo@klaralvdalens-datakonsult.se>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    As a special exception, permission is given to link this program
    with any edition of Qt, and distribute the resulting executable,
    without including the source code for Qt in the source distribution.
*/

#include "incidenceconflictdialog.h"

#include <libkcal/incidence.h>
#include <libkcal/icalformat.h>

#include <qpushbutton.h>
#include <qtextedit.h>
#include <qlabel.h>
#include <qlayout.h>
#include <qtabwidget.h>
#include <qgrid.h>
#include <klocale.h>


IncidenceConflictDialog::IncidenceConflictDialog( QWidget* parent, const char* name,
						  bool modal, WFlags f )
  : QDialog( parent, name, modal, f ), mChoice( 0 )
{
  QVBoxLayout* topLayout = new QVBoxLayout( this, 10, 10, "Top layout" );

  QString header = i18n( "<h2><p align=\"center\">Conflicting incidences!</p></h2>" );
  topLayout->addWidget( new QLabel( header, this ) );
  label = new QLabel( this, "Header label" );
  topLayout->addWidget( label );
  QTabWidget* tabs = new QTabWidget( this, "Incidence views" );
  topLayout->addWidget( tabs );
  tab1 = new QTextEdit( tabs, "Tab1" );
  tabs->addTab( tab1, i18n("Local contents") );
  tab2 = new QTextEdit( tabs, "Tab2" );
  tabs->addTab( tab2, i18n("Server Contents") );

  QHBoxLayout* buttons = new QHBoxLayout( topLayout );
  buttons->addStretch( 1 );
  QGrid* grid = new QGrid( 3, Horizontal, this, "Button grid" );
  grid->setSpacing( 10 );
  buttons->addWidget( grid );
  buttons->addStretch( 1 );
  QPushButton* b = new QPushButton( i18n("Keep &Local Contents"), grid, "Keep local button" );
  connect( b, SIGNAL( clicked() ), this, SLOT( slotKeepLocal() ) );
  b = new QPushButton( i18n("Keep &Server Contents"), grid, "Keep server button" );
  connect( b, SIGNAL( clicked() ), this, SLOT( slotKeepServer() ) );
  b = new QPushButton( i18n("Keep &Both"), grid, "Keep Both button" );
  connect( b, SIGNAL( clicked() ), this, SLOT( accept() ) );
}


IncidenceConflictDialog::~IncidenceConflictDialog()
{
}

void IncidenceConflictDialog::setIncidences( KCal::Incidence* newIncidence, KCal::Incidence* oldIncidence )
{
  KCal::ICalFormat f;
  tab1->setText( f.toString( newIncidence ) );
  tab2->setText( f.toString( oldIncidence ) );

  setLabel( newIncidence->type() );
}

void IncidenceConflictDialog::slotKeepLocal()
{
  mChoice = 1;
  accept();
}


void IncidenceConflictDialog::slotKeepServer()
{
  mChoice = 2;
  accept();
}


void IncidenceConflictDialog::setLabel( const QCString& incidenceType )
{
  QString contents;
  if( incidenceType == "Event" )
    contents = i18n("<p>Two events have the same ID. This usually happens if you have modified the same event from two different machines. You can choose which of them - or both - you want to keep.</p><p>You can see the text of them in the two tabs below.</p><p>Warning: If you choose to keep only one, you will not have access to the other again! So, if you need some information from it, take it from the text below</p>");
  else if( incidenceType == "Todo" )
    contents = i18n("<p>Two tasks have the same ID. This usually happens if you have modified the same task from two different machines. You can choose which of them - or both - you want to keep.</p><p>You can see the text of them in the two tabs below.</p><p>Warning: If you choose to keep only one, you will not have access to the other again! So, if you need some information from it, take it from the text below</p><p>If you keep both tasks, the new one will not be associated with any subtasks</p>");
  else
    contents = i18n("<p>Two incidences have the same ID. Please choose which of them you want to keep</p>");
  label->setText( contents );
}
