/*
    Copyright (C) 2010  Bertjan Broeksema b.broeksema@home.nl

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License along
    with this program; if not, write to the Free Software Foundation, Inc.,
    51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.

*/

#ifndef INCIDENCEDATETIMEEDITOR_H
#define INCIDENCEDATETIMEEDITOR_H

#include "incidenceeditor-ng.h"
#include "../incidenceeditors_export.h"

#include <KCal/Event>
#include <KCal/Todo>

namespace KCal {
class ICalTimeZones;
}

namespace Ui {
class IncidenceDateTimeEditor;
}

namespace IncidenceEditorsNG {

class INCIDENCEEDITORS_EXPORT IncidenceDateTimeEditor : public IncidenceEditor
{
  Q_OBJECT
  public:
    IncidenceDateTimeEditor( QWidget *parent = 0 );
    ~IncidenceDateTimeEditor();

    virtual void load( KCal::Incidence::ConstPtr incidence );
    virtual void save( KCal::Incidence::Ptr incidence );
    virtual bool isDirty() const;

    /**
     * Sets the active date for the editing session. This defaults to the current
     * date. It should be set <em>before</em> loading a non-empty (i.e. existing
     * incidence).
     */
    void setActiveDate( const QDate &activeDate );

  private slots: /// General
    void editRecurrence();
    void enableAlarm( bool enable );
    void startTimeChanged( const QTime &newtime );
    void updateRecurrenceSummary( KCal::Incidence::ConstPtr incidence );
    
  private slots: /// Todo specific
    void enableStartEdit( bool enable );
    void enableEndEdit( bool enable );
    void enableTimeEdits( bool enable );
    bool isDirty( KCal::Todo::ConstPtr todo ) const;

  private slots: /// Event specific
    bool isDirty( KCal::Event::ConstPtr event ) const;
    
  private:
    /// Created from the values in the widgets
    KDateTime currentStartDateTime() const; 
    KDateTime currentEndDateTime() const;
    
    void load( KCal::Event::ConstPtr event );
    void load( KCal::Todo::ConstPtr todo );
    void setDateTimes( const KDateTime &start, const KDateTime &end );
    void setTimes( const KDateTime &start, const KDateTime &end );
    void setDuration();
    
  private:
    KCal::ICalTimeZones *mTimeZones;
    Ui::IncidenceDateTimeEditor *mUi;

    QDate mActiveDate;
    /**
     * These might differ from mLoadedIncidence->(dtStart|dtDue) as these take
     * in account recurrence if needed. The values are calculated once on load().
     * and don't change afterwards.
     */
    KDateTime mActiveStartDT;
    KDateTime mActiveEndDT;
};

} // IncidenceEditorsNG

#endif // INCIDENCEDATETIMEEDITOR_H
