/***************************************************************************
 *   Copyright (C) 2011 by Francesco Nwokeka <francesco.nwokeka@gmail.com> *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA            *
 ***************************************************************************/

#include "generalsettings.h"

GeneralSettings::GeneralSettings(TelepathyPresenceApplet::OnClickAction clickAction, QWidget *parent)
    : QWidget(parent)
    , ui(new Ui::GeneralSettings)
{
    ui->setupUi(this);

    // set current on click action
    if (clickAction == TelepathyPresenceApplet::SHOW_ACCOUNT_MANAGER) {
        ui->showAccountManagerRadio->setChecked(true);
    } else if (clickAction == TelepathyPresenceApplet::SHOW_CONTACTLIST) {
        ui->showContactListRadio->setChecked(true);
    } else {
        ui->doNothingRadio->setChecked(true);
    }

    connect(ui->doNothingRadio, SIGNAL(toggled(bool)), this, SIGNAL(modified()));
    connect(ui->showContactListRadio, SIGNAL(toggled(bool)), this, SIGNAL(modified()));
    connect(ui->showAccountManagerRadio, SIGNAL(toggled(bool)), this, SIGNAL(modified()));
}

GeneralSettings::~GeneralSettings()
{
    delete ui;
}

void GeneralSettings::save()
{
    qDebug("GENERAL SETTINGS SAVE");
    KSharedConfigPtr config = KSharedConfig::openConfig(QLatin1String("ktelepathyrc"));
    KConfigGroup presenceConfig = config->group("PresencePlasmoid");

    if (ui->doNothingRadio->isChecked()) {
        presenceConfig.writeEntry("onClick", "nothing");
        emit clickActionUpdated(TelepathyPresenceApplet::DO_NOTHING);
    } else if (ui->showContactListRadio->isChecked()) {
        presenceConfig.writeEntry("onClick", "contactlist");
        emit clickActionUpdated(TelepathyPresenceApplet::SHOW_CONTACTLIST);
    } else if (ui->showAccountManagerRadio->isChecked()) {
        presenceConfig.writeEntry("onClick", "accounts");
        emit clickActionUpdated(TelepathyPresenceApplet::SHOW_ACCOUNT_MANAGER);
    }

    presenceConfig.sync();
}



