/* ============================================================
 *
 * This file is a part of digiKam project
 * https://www.digikam.org
 *
 * Date        : 2008-11-27
 * Description : a view to show Batch Tool Settings.
 *
 * SPDX-FileCopyrightText: 2008-2022 by Gilles Caulier <caulier dot gilles at gmail dot com>
 *
 * SPDX-License-Identifier: GPL-2.0-or-later
 *
 * ============================================================ */

#ifndef DIGIKAM_BQM_TOOL_SETTINGS_VIEW_H
#define DIGIKAM_BQM_TOOL_SETTINGS_VIEW_H

// Qt includes

#include <QStackedWidget>

// Local includes

#include "batchtool.h"
#include "batchtoolutils.h"

namespace Digikam
{

class ToolSettingsView : public QStackedWidget
{
    Q_OBJECT

public:

    explicit ToolSettingsView(QWidget* const parent = nullptr);
    ~ToolSettingsView() override;

    void setBusy(bool b);

Q_SIGNALS:

    void signalSettingsChanged(const BatchToolSet&);

public Q_SLOTS:

    void slotToolSelected(const BatchToolSet&);

private Q_SLOTS:

    void slotSettingsChanged(const BatchToolSettings&);
    void slotThemeChanged();
    void slotAboutPlugin();

private:

    int  viewMode() const;
    void setViewMode(int mode);
    void setToolSettingsWidget(QWidget* const w);

private:

    class Private;
    Private* const d;
};

} // namespace Digikam

#endif // DIGIKAM_BQM_TOOL_SETTINGS_VIEW_H
