/*
 *
 *  Kepas - KDE Easy Publish and Share
 *
 *  Copyright (C) 2008  Tom Patzig <tpatzig@suse.de>
 *
 *  This file is part of kepas.
 *
 *  kepas is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  kepas is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with kepas; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
*/

#ifndef TRAYICON_H
#define TRAYICON_H

#include <QtGui>
#include <QtDBus>
#include <QSystemTrayIcon>
#include <kconfig.h>
#include <KApplication>
#include <KMessageBox>
#include <kdialog.h>
#include <kaboutapplicationdialog.h>
#include <kaboutdata.h>
#include <QMainWindow>

#include <lib/servicelocator.h>
#include <lib/buddylist.h>
#include <lib/ui_config.h>


class TrayIcon : public QObject
//class TrayIcon : public QMainWindow
	 	 	 	 
{
Q_OBJECT


public:
	 TrayIcon(QObject* parent = 0);
	 ~TrayIcon();
	 
private:
	 QSystemTrayIcon* tray;
//	 KSystemTrayIcon* tray;
	 ServiceLocator* avahiClient;
	 QMenu* mainmenu;
	 QMenu* clipMenu;

	 QAction* buddyAction;
	 QAction* serverAction;
	 QAction* configAction;
	 QAction* clipAction;
	 QAction* quitAction;
	 QAction* sendFileAction;
	 BuddyList* buddylist;
//	 KConfig* config;

	 QDBusConnection* dbus;
	 KDialog* m_dialog;
	 Ui::Config ui;
	 
	 
	 void addClipEntries();	 

public slots:
	 void slotBuddyList(bool);
	 void slotServerWizard(bool);
	 void slotSendClipEntry(QAction*);
	 void slotQuitApp(bool);
	 void slotTrayActivated(QSystemTrayIcon::ActivationReason reason);
	 void slotShowToolTip(QAction* action);
	 void slotFileSelect(bool);
	
	 void configAccepted();
	 void slotSelectDir();
	 void showConfigurationInterface();
	 void serviceRunning();
	 void showAboutInfo();
	

};




#endif
