/***************************************************************************
 *   Copyright (C) 2006 by Thomas Kadauke                                  *
 *   tkadauke@gmx.de                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,      *
 *   Boston, MA 02110-1301, USA.                                           *
 ***************************************************************************/

// Qt includes
#include <qvaluelist.h>
#include <qobjectlist.h>
#include <qtimer.h>

// WorKflow includes
#include "widget.h"
#include "widgetinterface.h"
#include "command.h"
#include "parameter.h"

using namespace WorKflow;

typedef QValueList<WidgetInterface*> WidgetList;

class Widget::Private
{
public:
  Command* command;
};

Widget::Widget(QWidget* parent, const char* name, WFlags f)
  : QWidget(parent, name, f)
{
  d = new Private;
  d->command = 0;
}

Widget::~Widget()
{
  delete d;
}

void Widget::initChildren()
{
  disconnect(this, SLOT(emitChange()));

  recurseObjects(this);
}

void Widget::emitChange()
{
  emit changed();
}

void Widget::setCommand(Command* cmd)
{
  d->command = cmd;
  connect(this, SIGNAL(changed()), cmd, SLOT(notifyChange()));
  connect(this, SIGNAL(sizeChanged()), cmd, SIGNAL(sizeChanged()));
  QTimer::singleShot(0, this, SLOT(initChildren()));
}

Command* Widget::command()
{
  return d->command;
}

void Widget::recurseObjects(QObject* obj)
{
  const QObjectList* l = obj->children();
  if (!l)
    return;

  QObjectListIt it(*l);
  QObject* o;

  while ((o = it.current()) != 0) {
    ++it;
    WidgetInterface* iface = static_cast<WidgetInterface*>(o->qt_cast("WorKflow::WidgetInterface"));
    if (iface) {
      iface->setCommand(d->command);

      // we assume that the widget has a changed() signal and a setValue() slot.
      // If not, we get a warning which doesn't hurt too much
      connect(o, SIGNAL(changed(const Value&)), iface->parameter(), SLOT(setStaticValue(const Value&)));
      connect(iface->parameter(), SIGNAL(changed(const Value&)), this, SLOT(emitChange()));
      connect(iface->parameter(), SIGNAL(changed(const Value&)), o, SLOT(setValue(const Value&)));
    }

    recurseObjects(o);
  }
}

#include "widget.moc"
