/***************************************************************************
 *   Copyright (C) 2006 by Thomas Kadauke                                  *
 *   tkadauke@gmx.de                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,      *
 *   Boston, MA 02110-1301, USA.                                           *
 ***************************************************************************/

// KDE includes
#include <klocale.h>

// Qt includes
#include <qcombobox.h>
#include <qpushbutton.h>
#include <qlayout.h>

// WorKflow includes
#include "filenamefilterwidget.h"
#include "editfilenamefilterdialog.h"
#include "parameter.h"

using namespace WorKflow;

FilenameFilterWidget::FilenameFilterWidget(QWidget* parent, const char* name, WFlags fl)
  : QWidget(parent, name, fl)
{
  QGridLayout* layout = new QGridLayout(this, 1, 2);

  m_comboBox = new QComboBox(this);
  m_comboBox->setSizePolicy(QSizePolicy::Expanding, QSizePolicy::Fixed);
  layout->addWidget(m_comboBox, 0, 0);

  m_editButton = new QPushButton(i18n("Edit..."), this);
  layout->addWidget(m_editButton, 0, 1);

  connect(m_editButton, SIGNAL(clicked()), this, SLOT(editFilter()));
  connect(m_comboBox, SIGNAL(activated(int)), this, SLOT(slotChanged()));

  m_filters[i18n("Text files")] = i18n("*.txt|Text Files");
  m_filters[i18n("Image files")] = i18n("*.jpg|JPEG Images\n*.png|PNG images");

  m_comboBox->insertItem("Custom...");
  m_comboBox->insertStringList(m_filters.keys());
}

FilenameFilterWidget::~FilenameFilterWidget()
{
}

void FilenameFilterWidget::editFilter()
{
  QStringList filters = value().asStringList();
  if (EditFilenameFilterDialog::edit(this, filters)) {
    setValue(Value::stringList(parameter()->typeId(), filters));
    emit changed(value());
  }
}

Value FilenameFilterWidget::value()
{
  if (m_comboBox->currentItem() != 0) {
    QStringList filters = QStringList::split("\n", m_filters[m_comboBox->currentText()]);
    return Value::stringList(parameter()->typeId(), filters);
  }

  return Value::stringList(parameter()->typeId(), m_value);
}

void FilenameFilterWidget::setParameterId(const QString& paramId)
{
  WidgetInterface::setParameterId(paramId);
}

QString FilenameFilterWidget::parameterId() const
{
  return WidgetInterface::parameterId();
}

void FilenameFilterWidget::setValue(const Value& value)
{
  QStringList filters = value.asStringList();

  // find filter in list of known filters
  QString filter = filters.join("\n");

  QValueList<QString> keys = m_filters.keys();
  QValueList<QString> values = m_filters.values();

  int pos = values.findIndex(filter);
  if (pos != -1) {
    m_comboBox->setCurrentItem(pos + 1);
  } else {
    m_comboBox->setCurrentItem(0);
    m_value = filters;
  }
}

void FilenameFilterWidget::slotChanged()
{
  if (!parameter())
    return;

  emit changed(value());
}

#include "filenamefilterwidget.moc"
