/***************************************************************************
 *   Copyright (C) 2006 by Thomas Kadauke                                  *
 *   tkadauke@gmx.de                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,      *
 *   Boston, MA 02110-1301, USA.                                           *
 ***************************************************************************/

#include "applicationcombobox.h"

using namespace WorKflow;

class ApplicationComboBox::Private
{
public:
  Private(ApplicationComboBox* pub);

  ApplicationType appType;

private:
  ApplicationComboBox* p;
};

ApplicationComboBox::Private::Private(ApplicationComboBox* pub)
  : p(pub), appType(Known)
{
}

ApplicationComboBox::ApplicationComboBox(QWidget* parent, const char* name)
  : QComboBox(parent, name), WidgetInterface()
{
  d = new Private(this);

}

ApplicationComboBox::~ApplicationComboBox()
{
  delete d;
}

QString ApplicationComboBox::parameterId() const
{
  return WidgetInterface::parameterId();
}

Value ApplicationComboBox::value()
{
}

void ApplicationComboBox::setParameterId(const QString& paramId)
{
  WidgetInterface::setParameterId(paramId);
}

void ApplicationComboBox::setValue(const Value& value)
{
}

ApplicationComboBox::ApplicationType ApplicationComboBox::appType() const
{
  return d->appType;
}

void ApplicationComboBox::setAppType(ApplicationType type)
{
  d->appType = type;
  repopulate();
}

void ApplicationComboBox::repopulate()
{
}

#include "applicationcombobox.moc"
