/***************************************************************************
 *   Copyright (C) 2006 by Thomas Kadauke                                  *
 *   tkadauke@gmx.de                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,      *
 *   Boston, MA 02110-1301, USA.                                           *
 ***************************************************************************/

// KDE includes
#include <kprogress.h>
#include <kapplication.h>

// Qt includes
#include <ksqueezedtextlabel.h>

// WorKflow includes
#include "progressdialog.h"

using namespace WorKflow;

ProgressDialog::ProgressDialog(QWidget* parent, const char* name, bool modal, WFlags fl)
  : ProgressDialogBase(parent,name, modal,fl)
{
}

ProgressDialog::~ProgressDialog()
{
}

void ProgressDialog::showProgress(double total, double current, const QString& name, const QString& task)
{
  m_overallProgress->setProgress(int(total * 100));
  m_currentProgress->setProgress(int(current * 100));
  m_commandNameLabel->setText(name);
  m_taskLabel->setText(task);

  kapp->processEvents();
}

void ProgressDialog::reject()
{
  emit cancelled();
  QDialog::reject();
}

#include "progressdialog.moc"
