/***************************************************************************
 *   Copyright (C) 2006 by Thomas Kadauke                                  *
 *   tkadauke@gmx.de                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,      *
 *   Boston, MA 02110-1301, USA.                                           *
 ***************************************************************************/

// WorKflow includes
#include "xmldescription.h"

// designer includes
#include "librarylistitem.h"

using namespace WorKflow;

LibraryListItem::LibraryListItem(QListViewItem* parent, XMLDescription* desc)
  : QListViewItem(parent), m_description(desc)
{
  update();
}

LibraryListItem::~LibraryListItem()
{
}

XMLDescription* LibraryListItem::description() const
{
  return m_description;
}

void LibraryListItem::update()
{
  setText(0, m_description->name());
  setText(1, m_description->id());
}
