/***************************************************************************
 *   Copyright (C) 2006 by Thomas Kadauke                                  *
 *   tkadauke@gmx.de                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,      *
 *   Boston, MA 02110-1301, USA.                                           *
 ***************************************************************************/

// Qt includes
#include <qlineedit.h>

// WorKflow includes
#include "librarydescription.h"

// designer includes
#include "librarydialog.h"

using namespace WorKflow;

bool LibraryDialog::editLibrary(QWidget* parent, WorKflow::LibraryDescription* desc)
{
  LibraryDialog dialog(parent, desc);
  return dialog.exec();
}

WorKflow::LibraryDescription* LibraryDialog::newLibrary(QWidget* parent)
{
  LibraryDescription* desc = new LibraryDescription;

  LibraryDialog dialog(parent, desc);
  if (dialog.exec()) {
    return dialog.m_description;
  } else {
    delete desc;
    return 0;
  }
}

LibraryDialog::LibraryDialog( QWidget * parent, WorKflow::LibraryDescription * desc )
    : LibraryDialogBase(parent), m_description(desc)
{
  init();
}

LibraryDialog::~LibraryDialog()
{
}

void LibraryDialog::init()
{
  m_idEdit->setText(m_description->id());
  m_nameEdit->setText(m_description->name());
  m_descriptionEdit->setText(m_description->description());
}

void LibraryDialog::accept()
{
  m_description->setId(m_idEdit->text());
  m_description->setName(m_nameEdit->text());
  m_description->setDescription(m_descriptionEdit->text());

  QDialog::accept();
}

#include "librarydialog.moc"
