/***************************************************************************
 *   Copyright (C) 2006 by Thomas Kadauke                                  *
 *   tkadauke@gmx.de                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,      *
 *   Boston, MA 02110-1301, USA.                                           *
 ***************************************************************************/

// KDE includes
#include <kdebug.h>

// Qt includes
#include <qlistbox.h>
#include <qpushbutton.h>
#include <qlineedit.h>

// WorKflow includes
#include "result.h"
#include "command.h"
#include "datatype.h"

// debugger includes
#include "resultinspector.h"

using namespace WorKflow;

typedef Command::ResultList ResList;

ResultInspector* ResultInspector::s_self = 0;

ResultInspector* ResultInspector::self()
{
  if (!s_self) {
    s_self = new ResultInspector();
  }
  return s_self;
}

ResultInspector::ResultInspector()
  : ResultInspectorBase(), m_command(0)
{
}

ResultInspector::~ResultInspector()
{
}

void ResultInspector::setCommand(WorKflow::Command* command)
{
  m_command = command;

  m_resultListBox->clear();
  ResList results = m_command->resultList();
  for (ResList::ConstIterator i = results.begin(); i != results.end(); ++i) {
    Result* result = *i;
    m_resultListBox->insertItem(QString("%1 (%2)").arg(result->name()).arg(result->id()));
  }

  m_resultListBox->setEnabled(true);

  updateInspector();
}

void ResultInspector::showDatatypeInfo()
{}

void ResultInspector::updateInspector()
{
  if (!m_command)
    return;

  int index = m_resultListBox->index(m_resultListBox->selectedItem());

  Result* result = 0;

  int count = 0;
  ResList results = m_command->resultList();
  for (ResList::ConstIterator i = results.begin(); i != results.end(); ++i, ++count) {
    if (count == index) {
      result = *i;
      break;
    }
  }

  if (!result)  {
    m_idEdit->setText("");
    m_nameEdit->setText("");
    m_datatypeEdit->setText("");

    m_valueListBox->clear();
    return;
  }

  m_idEdit->setText(result->id());
  m_nameEdit->setText(result->name());
  m_datatypeEdit->setText(QString("%1 (%2)").arg(result->type()->name()).arg(result->typeId()));

  m_valueListBox->clear();

  Value value = result->value();
  QStringList valueItems = value.asStringList();

  m_valueListBox->insertStringList(valueItems);
}

void ResultInspector::showEvent(QShowEvent*)
{
  emit visibilityChanged();
}

void ResultInspector::hideEvent(QHideEvent*)
{
  emit visibilityChanged();
}

#include "resultinspector.moc"
