/***************************************************************************
 *   Copyright (C) 2006 by Thomas Kadauke                                  *
 *   tkadauke@gmx.de                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,      *
 *   Boston, MA 02110-1301, USA.                                           *
 ***************************************************************************/

#ifndef MAINWINDOW_H
#define MAINWINDOW_H

// KDE includes
#include <kmainwindow.h>

// Qt includes
#include <qtimer.h>

// WorKflow includes
#include "commandmanager.h"

// forward declarations
class KToggleAction;

class QComboBox;
class QVBoxLayout;

namespace WorKflow
{
  class Command;
  class CommandWidget;
  class Document;
}

/**
 * @author Thomas Kadauke
 */
class MainWindow : public KMainWindow
{
  Q_OBJECT

public:
  MainWindow(const QString& category = "", const QString& command = "");
  ~MainWindow();

protected:
  void setupActions();

private slots:
  void slotLibrariesLoaded();
  void fillCommandCombo(int category);
  void showCommand(int command);
  void slotCommandChanged();
  void slotCommandResized();
  void statusBarTimeout();
  void updateActionState();

  void showParameterInspector();
  void showResultInspector();
  void executeCommand();

private:
  typedef WorKflow::CommandManager::CategoryList CatList;
  typedef WorKflow::CommandManager::DescriptionList CommandList;

  WorKflow::Document* m_document;

  QComboBox* m_categoryCombo;
  QComboBox* m_commandCombo;

  QWidget* m_mainSpace;
  QVBoxLayout* m_mainLayout;
  WorKflow::Command* m_command;
  WorKflow::CommandWidget* m_commandWidget;
  CatList m_categories;
  CommandList m_commands;

  QTimer m_statusBarTimer;

  KToggleAction* m_paramInspector;
  KToggleAction* m_resultInspector;
  KAction* m_execute;
};

#endif
