/***************************************************************************
 *   Copyright (C) 2006 by Thomas Kadauke                                  *
 *   tkadauke@gmx.de                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,      *
 *   Boston, MA 02110-1301, USA.                                           *
 ***************************************************************************/

#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

// #include <kapplication.h>
#include <kmainwindow.h>

// forward declarations
class QSplitter;

class KURL;
class KListViewSearchLineWidget;
class KToggleAction;
class KRecentFilesAction;

namespace WorKflow
{
  class View;
  class CategoryListView;
  class CommandListView;
  class HelpWidget;
}

/**
 * This class serves as the main window for WorKflow.  It handles the
 * menus, toolbars, and status bars.
 *
 * @short Main window class
 * @author Thomas Kadauke <tkadauke@gmx.de>
 */
class MainWindow : public KMainWindow
{
  Q_OBJECT
public:
  /**
   * Default Constructor
   */
  MainWindow();

  /**
   * Default Destructor
   */
  virtual ~MainWindow();

  void openOnStartup(const KURL& url, bool exec);

public slots:
  void init();

  void fileNew();
  void fileOpen();
  void fileOpen(const KURL& url);
  bool fileSave();
  bool fileSaveAs();
  void filePrint();
  void exportWorkflow();
  void importWorkflow();
  void optionsPreferences();

  void toggleFullScreen();

  void execute();

protected:
  virtual void dragEnterEvent(QDragEnterEvent *event);
  virtual void dropEvent(QDropEvent *event);
  virtual bool queryClose();

protected:
  /**
   * This function is called when it is time for the app to save its
   * properties for session management purposes.
   */
  void saveProperties(KConfig *);

  /**
   * This function is called when this app is restored.  The KConfig
   * object points to the session management config file that was saved
   * with @ref saveProperties
   */
  void readProperties(KConfig *);


private slots:
  void changeStatusbar(const QString& text);

  void changeActionState();

private:
  void setupAccel();
  void setupActions();
  void readSettings();
  void writeSettings();
  void updateCaption();

  MainWindow* newWindow();

private:
  QSplitter* m_splitter;
  QSplitter* m_helpSplitter;
  WorKflow::CategoryListView* m_categoryList;
  WorKflow::CommandListView* m_commandList;
  WorKflow::View* m_view;
  WorKflow::HelpWidget* m_helpWidget;
  KListViewSearchLineWidget* m_searchLine;

  KRecentFilesAction* m_openRecent;
  KAction* m_save;

  KAction* m_cut;
  KAction* m_copy;
  KAction* m_paste;
  KAction* m_undo;
  KAction* m_redo;
  KAction* m_deselect;

  KAction* m_collapseAll;
  KAction* m_uncollapseAll;

  KToggleAction* m_fullscreen;

  KAction* m_execute;

  KURL m_startupUrl;
  bool m_justExecute;
};

#endif
