/***************************************************************************
 *   Copyright (C) 2006 by Thomas Kadauke                                  *
 *   tkadauke@gmx.de                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,      *
 *   Boston, MA 02110-1301, USA.                                           *
 ***************************************************************************/

#ifndef WORKFLOWXMLDESCRIPTION_H
#define WORKFLOWXMLDESCRIPTION_H

#include <qstring.h>

// forward declarations
class QDomDocument;
class QDomElement;

namespace WorKflow
{
  /**
  @author Thomas Kadauke
  */
  class XMLDescription
  {
  public:
    XMLDescription();
    virtual ~XMLDescription();

    QString id() const;
    QString name() const;
    QString description() const;

    void setId(const QString& id);
    void setName(const QString& name);
    void setDescription(const QString& desc);

    virtual void readXML(const QDomElement& e);
    virtual void writeXML(QDomDocument& doc, QDomElement& e);

  private:
    QString m_id;
    QString m_name;
    QString m_description;
  };

}

#endif
