/***************************************************************************
 *   Copyright (C) 2006 by Thomas Kadauke                                  *
 *   tkadauke@gmx.de                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,      *
 *   Boston, MA 02110-1301, USA.                                           *
 ***************************************************************************/

#ifndef WORKFLOWPARAMETERDESCRIPTION_H
#define WORKFLOWPARAMETERDESCRIPTION_H

// WorKflow includes
#include "slotdescription.h"
#include "parameter.h"

namespace WorKflow
{
  /**
   * @author Thomas Kadauke
   */
  class ParameterDescription : public SlotDescription
  {
  public:
    ParameterDescription(CommandDescription* parent);
    ~ParameterDescription();

    bool isOptional() const;
    Parameter::Source source() const;

    void setOptional(bool optional);
    void setSource(Parameter::Source source);

    virtual void readXML(const QDomElement& e);
    virtual void writeXML(QDomDocument& doc, QDomElement& e);

//   protected:
//     virtual bool handleProperty(const QString& key, const QString& value);

  private:
    bool m_optional;
    Parameter::Source m_source;
    // TODO: default value
  };
}

#endif
