/***************************************************************************
 *   Copyright (C) 2006 by Thomas Kadauke                                  *
 *   tkadauke@gmx.de                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,      *
 *   Boston, MA 02110-1301, USA.                                           *
 ***************************************************************************/

// KDE includes
#include <kdebug.h>

// Qt includes
#include <qdom.h>

// WorKflow includes
#include "category.h"
#include "commandmanager.h"
#include "librarydescription.h"

using namespace WorKflow;

class Category::Private
{
public:
  LibraryDescription* parent;
  QString iconName;
};

Category::Category(LibraryDescription* parent)
  : XMLDescription()
{
  d = new Private;
  d->parent = parent;
  d->parent->addCategory(this);
  CommandManager::self()->registerCategory(this);
}

Category::~Category()
{
  d->parent->removeCategory(this);
  CommandManager::self()->unregisterCategory(this);
  delete d;
}

QString Category::iconName() const
{
  return d->iconName;
}

void Category::setIconName(const QString& iconName)
{
  d->iconName = iconName;
}

void Category::readXML(const QDomElement& e)
{
  XMLDescription::readXML(e);

  QDomNode n = e.firstChild();
  while (!n.isNull()) {
    QDomElement e = n.toElement();
    if (!e.isNull()) {
      if (e.tagName() == "icon") {
        QString name = e.attribute("name");
        setIconName(name);
      }
    }
    n = n.nextSibling();
  }
}

void Category::writeXML(QDomDocument& doc, QDomElement& e)
{
  QDomElement cat = doc.createElement("category");
  XMLDescription::writeXML(doc, cat);

  if (!d->iconName.isEmpty()) {
    QDomElement icon = doc.createElement("icon");
    icon.setAttribute("name", d->iconName);
  }

  e.appendChild(cat);
}
