/***************************************************************************
 *   Copyright (C) 2006 by Thomas Kadauke                                  *
 *   tkadauke@gmx.de                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,      *
 *   Boston, MA 02110-1301, USA.                                           *
 ***************************************************************************/

// KDE includes
#include <kapplication.h>
#include <klocale.h>

// Qt includes
#include <qtimer.h>
#include <qdatetime.h>

// command includes
#include "waitcommand.h"
#include "waitwidget.h"

using namespace WorKflow;

WaitCommand::WaitCommand(Document* parent, CommandDescription* description)
  : Command(parent, description)
{
  WaitWidget* w = new WaitWidget(this);
  setWidget(w);

  connect(&m_progressTimer, SIGNAL(timeout()), this, SLOT(showProgress()));
}

WaitCommand::~WaitCommand()
{
}

void WaitCommand::execute()
{
  QTime time = QTime::fromString(value("time").nextString());
  int seconds = QTime(0, 0, 0).secsTo(time);

  QTimer::singleShot(seconds * 1000, this, SLOT(finish()));
  m_startTime.start();
  m_progressTimer.start(100);

  kapp->enter_loop();

  Command::execute();
}

void WaitCommand::finish()
{
  m_progressTimer.stop();
  kapp->exit_loop();
}

void WaitCommand::showProgress()
{
  QTime totalTime = QTime::fromString(value("time").nextString());
  int elapsedMsecs = m_startTime.elapsed();
  int totalMsecs = QTime().msecsTo(totalTime);

  int left = totalMsecs - elapsedMsecs;
  int leftMsecs = left % 1000;
  left /= 1000;
  int leftSecs = left % 60;
  left /= 60;
  int leftMins = left % 60;
  int leftHours = left / 60;
  QTime leftTime(leftHours, leftMins, leftSecs, leftMsecs);

  emit progress(double(elapsedMsecs) / double(totalMsecs), i18n("Waiting (%1 left)").arg(leftTime.toString()));
}

#include "waitcommand.moc"
