/***************************************************************************
 *   Copyright (C) 2006 by Thomas Kadauke                                  *
 *   tkadauke@gmx.de                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,      *
 *   Boston, MA 02110-1301, USA.                                           *
 ***************************************************************************/

// command includes
#include "truncatelistcommand.h"
#include "truncatelistwidget.h"

using namespace WorKflow;

TruncateListCommand::TruncateListCommand(Document* parent, CommandDescription* description)
  : Command(parent, description)
{
  TruncateListWidget* w = new TruncateListWidget(this);
  setWidget(w);
}

TruncateListCommand::~TruncateListCommand()
{
}

void TruncateListCommand::execute()
{
  QStringList input = value("input").asStringList();
  QStringList output;

  int firstorlast = value("firstorlast").nextNumber();
  bool first = (firstorlast == 0);
  unsigned int numitems = value("numitems").nextNumber();

  if (numitems > input.count())
    numitems = input.count();

  QStringList::ConstIterator begin, end;
  if (first) {
    begin = input.begin();
    end = input.at(numitems);
  } else {
    begin = input.at(input.count() - numitems);
    end = input.end();
  }

  for (QStringList::ConstIterator i = begin; i != end; ++i) {
    output << *i;
  }

  setResult("output", Value::stringList("org.kde.public.anything", output));
}

#include "truncatelistcommand.moc"
