/***************************************************************************
 *   Copyright (C) 2006 by Thomas Kadauke                                  *
 *   tkadauke@gmx.de                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,      *
 *   Boston, MA 02110-1301, USA.                                           *
 ***************************************************************************/

// WorKflow includes
#include "parameter.h"

// command includes
#include "changetextcasecommand.h"
#include "changetextcasewidget.h"

using namespace WorKflow;

ChangeTextCaseCommand::ChangeTextCaseCommand(Document* parent, CommandDescription* description)
  : Command(parent, description)
{
  ChangeTextCaseWidget* w = new ChangeTextCaseWidget(this);
  setWidget(w);
}

ChangeTextCaseCommand::~ChangeTextCaseCommand()
{
}

void ChangeTextCaseCommand::execute()
{
  QStringList text = value("input").asStringList();
  QString textCase = value("textcase").nextString();

  for (QStringList::Iterator i = text.begin(); i != text.end(); ++i)
    if (textCase == "lower")
      (*i) = (*i).lower();
    else if (textCase == "upper")
      (*i) = (*i).upper();
    else if (textCase == "title")
      (*i) = titleCase(*i);
    else if (textCase == "sentence")
      (*i) = sentenceCase(*i);

  setResult("output", Value::stringList(parameter("input")->typeId(), text));
}

QString ChangeTextCaseCommand::titleCase(const QString& str)
{
  QString result;
  bool newWord = true;

  for (unsigned int i = 0; i != str.length(); i++) {
    QChar c = str[i];
    if (c.isLetter()) {
      if (newWord)
        result += c.upper();
      else
        result += c.lower();
      newWord = false;
    } else {
      if (c.isSpace() || c.isPunct())
        newWord = true;
      result += c;
    }
  }

  return result;
}

QString ChangeTextCaseCommand::sentenceCase(const QString& str)
{
  QString result;
  bool newSentence = true;

  for (unsigned int i = 0; i != str.length(); i++) {
    QChar c = str[i];
    if (c.isLetter()) {
      if (newSentence)
        result += c.upper();
      else
        result += c.lower();
      newSentence = false;
    } else {
      if (c.isPunct())
        newSentence = true;
      result += c;
    }
  }

  return result;
}

#include "changetextcasecommand.moc"
