/***************************************************************************
 *   Copyright (C) 2006 by Thomas Kadauke                                  *
 *   tkadauke@gmx.de                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,      *
 *   Boston, MA 02110-1301, USA.                                           *
 ***************************************************************************/

// KDE includes
#include <kgenericfactory.h>

// WorKflow includes
#include "standardlibrary.h"
#include "commandfactory.h"

// commands
#include "showmessagecommand.h"
#include "shellexecutecommand.h"
#include "waitcommand.h"

// list commands
#include "listcountcommand.h"
#include "listreversecommand.h"
#include "filterlistcommand.h"
#include "selectlistitemscommand.h"
#include "sortlistcommand.h"
#include "truncatelistcommand.h"

// variable commands
#include "storeinvariablecommand.h"
#include "loadfromvariablecommand.h"
#include "appendtovariablecommand.h"

// debug commands
#include "showoutputcommand.h"
#include "abortcommand.h"

// loop commands
#include "foreachcommand.h"

typedef KGenericFactory<StandardLibrary> LibraryFactory;
K_EXPORT_COMPONENT_FACTORY(libworkflow_stdcommands, LibraryFactory("libworkflow_stdcommands"))

StandardLibrary::StandardLibrary(QObject *parent, const char *name, const QStringList& args)
  : WorKflow::Library(parent, name, args)
{
}

StandardLibrary::~StandardLibrary()
{
}

void StandardLibrary::init()
{
  using namespace WorKflow;

  addCommandFactory(new CommandFactory<ShowMessageCommand>("org.kde.Standard.ShowMessage"));
  addCommandFactory(new CommandFactory<ShellExecuteCommand>("org.kde.Standard.ExecuteCommand"));
  addCommandFactory(new CommandFactory<WaitCommand>("org.kde.Standard.Wait"));

  addCommandFactory(new CommandFactory<ListCountCommand>("org.kde.Standard.ListCount"));
  addCommandFactory(new CommandFactory<ListReverseCommand>("org.kde.Standard.ReverseList"));
  addCommandFactory(new CommandFactory<FilterListCommand>("org.kde.Standard.FilterList"));
  addCommandFactory(new CommandFactory<SelectListItemsCommand>("org.kde.Standard.SelectListItems"));
  addCommandFactory(new CommandFactory<SortListCommand>("org.kde.Standard.SortList"));
  addCommandFactory(new CommandFactory<TruncateListCommand>("org.kde.Standard.TruncateList"));

  addCommandFactory(new CommandFactory<StoreInVariableCommand>("org.kde.Standard.StoreInVariable"));
  addCommandFactory(new CommandFactory<LoadFromVariableCommand>("org.kde.Standard.LoadFromVariable"));
  addCommandFactory(new CommandFactory<AppendToVariableCommand>("org.kde.Standard.AppendToVariable"));

  addCommandFactory(new CommandFactory<ShowOutputCommand>("org.kde.Standard.ShowOutput"));
  addCommandFactory(new CommandFactory<AbortCommand>("org.kde.Standard.Abort"));

  addCommandFactory(new CommandFactory<ForEachCommand>("org.kde.Standard.ForEach"));
}

#include "standardlibrary.moc"
