/***************************************************************************
 *   Copyright (C) 2006 by Thomas Kadauke                                  *
 *   tkadauke@gmx.de                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,      *
 *   Boston, MA 02110-1301, USA.                                           *
 ***************************************************************************/

// command includes
#include "selectlistitemscommand.h"
#include "selectlistitemswidget.h"
#include "selectlistitemsdialog.h"

using namespace WorKflow;

SelectListItemsCommand::SelectListItemsCommand(Document* parent, CommandDescription* description)
  : Command(parent, description)
{
  SelectListItemsWidget* w = new SelectListItemsWidget(this);
  setWidget(w);
}

SelectListItemsCommand::~SelectListItemsCommand()
{
}

void SelectListItemsCommand::execute()
{
  QStringList list = value("input").asStringList();
  QStringList res;

  QString prompt = value("prompt").nextString();
  bool allowMulti = value("multiple").nextBoolean();
  bool allowEmpty = value("empty").nextBoolean();

  if (!SelectListItemsDialog::select(widget(), title(), prompt, allowMulti, allowEmpty, list, res)) {
    emit aborted();
  }

  setResult("output", Value::stringList("org.kde.public.anything", res));
}

#include "selectlistitemscommand.moc"
