/***************************************************************************
 *   Copyright (C) 2006 by Thomas Kadauke                                  *
 *   tkadauke@gmx.de                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,      *
 *   Boston, MA 02110-1301, USA.                                           *
 ***************************************************************************/

// KDE includes
#include <kurl.h>
#include <klocale.h>

// Qt includes
#include <qwhatsthis.h>

// WorKflow includes
#include "imageviewer.h"

// command includes
#include "rotateimagedialog.h"
#include "rotateimagecommand.h"

RotateImageDialog::RotateImageDialog(const QStringList& files, QWidget* parent, const char* name, bool modal, WFlags fl)
  : RotateImageDialogBase(parent, name, modal, fl), m_files(files)
{
}

RotateImageDialog::~RotateImageDialog()
{
}

void RotateImageDialog::next()
{
  if (m_files.isEmpty()) {
    accept();
  } else {
    KURL url(m_files.first());
    m_current = url.path();

    m_files.pop_front();
    updatePreview();
  }
}

void RotateImageDialog::rotate180()
{
  RotateImageCommand::rotateImage(180, m_current);
  updatePreview();
}

void RotateImageDialog::rotateCCW()
{
  RotateImageCommand::rotateImage(-90, m_current);
  updatePreview();
}

void RotateImageDialog::rotateCW()
{
  RotateImageCommand::rotateImage(90, m_current);
  updatePreview();
}

void RotateImageDialog::setScaleImage(bool scale)
{
  m_preview->setAutoScale(scale);
  updatePreview();
}

void RotateImageDialog::showHelpText()
{
  static QString helpText = i18n("You can use the buttons on the bottom of the window to process the images."
                                 "Additionally, the following keyboard shortcuts exist:"
                                 "<ul>"
                                 "<li><b>C</b>: Rotate Clockwise"
                                 "<li><b>V</b>: Rotate Counter-Clockwise"
                                 "<li><b>B</b>: Rotate 180 Degrees"
                                 "<li><b>N</b>: Next Image"
                                 "</ul>");

  QWhatsThis::display(helpText);
}

void RotateImageDialog::updatePreview()
{
  m_preview->setImage(m_current);
}

bool RotateImageDialog::event( QEvent * e )
{
  if (e->type() == QEvent::KeyPress) {
    QKeyEvent* event = static_cast<QKeyEvent*>(e);

    switch (event->key()) {
      case Qt::Key_C:
        rotateCW();
        return true;
      case Qt::Key_V:
        rotateCCW();
        return true;
      case Qt::Key_B:
        rotate180();
        return true;
      case Qt::Key_N:
        next();
        return true;
      default:
        break;
    }
  }
  return QDialog::event(e);
}

void RotateImageDialog::showEvent(QShowEvent* e)
{
  next();
}

#include "rotateimagedialog.moc"
