/***************************************************************************
 *   Copyright (C) 2006 by Thomas Kadauke                                  *
 *   tkadauke@gmx.de                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,      *
 *   Boston, MA 02110-1301, USA.                                           *
 ***************************************************************************/

// KDE includes
#include <klocale.h>

// WorKflow includes
#include "document.h"
#include "result.h"

// command includes
#include "changevariablecommand.h"
#include "modifyvariableservice.h"

using namespace WorKflow;

ChangeVariableCommand::ChangeVariableCommand(Document* parent, CommandDescription* description)
  : Command(parent, description), m_service(0)
{
  // trigger type check when command is modified
  connect(this, SIGNAL(modified(Command*)), this, SLOT(updateService()));
}

ChangeVariableCommand::~ChangeVariableCommand()
{
}

QString ChangeVariableCommand::variableName()
{
  return value("variable").nextString();
}

void ChangeVariableCommand::updateService()
{
  if (m_service) {
    removeService(m_service);
    delete m_service;
  }

  if (row() == 0)
    return;

  Command* previous = document()->commandAt(row() - 1);
  Datatype* outtype = 0;
  if (previous && previous->output()) {
    outtype = previous->output()->type();
  }

  m_service = new ModifyVariableService(this, outtype, variableName(), i18n("Output of command %1").arg(previous->title()));
  addService(m_service);
}

#include "changevariablecommand.moc"
