#ifndef __KMTRACEVIEWER_MAIN_WINDOW_H__
#define __KMTRACEVIEWER_MAIN_WINDOW_H__

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

// KDE includes
#include <kmainwindow.h>
#include <kstatusbar.h>
#include <kaction.h>

// KMtraceViewer includes
#include "KMtraceModel.hh"
#include "KMtraceStatisticsView.hh"
#include "KMtraceLeaksView.hh"
#include "KMtraceSuppressListDialog.hh"
#include "KMtraceSourceCodeView.hh"

/**
 * The main windows of the application is divided into three parts:
 * @li On the top: a text area showing global statistics about the
 *     program being inspected (e.g. number of bytes leaked).
 *     This part is implemented in the class @ref KMtraceStatisticsView.
 * @li In the middle: a KListView like view which shows
 *     the memory leaks in an expandable list.
 *     This part is implemented in the class @ref KMtraceLeaksView
 * @li At the bottom: An editor of type @ref KMtraceSourceCodeView
 *     which shows the source code containing the memory leak which is
 *     currently selected in the KMtraceLeaksView.
 *
 * @short The main window of the kmtraceviewer application
 * @author Andreas Baumann <andreas_baumann@users.sourceforge.net>
 * @see KMtraceStatisticsView, KMtraceLeaksView, KMtraceSourceCodeView
 * @version $ProjectMajorVersion: 0 $
 */
class KMtraceViewerMainWindow : public KMainWindow
{
   Q_OBJECT

   public:
      /**
       * Creates a kmtrace viewer main window.
       *
       * @param ktreefile the name of the file containing the output
       *        of the kmtrace program
       */
      KMtraceViewerMainWindow( const char *ktreefile = 0 );

      ~KMtraceViewerMainWindow( );

      /**
       * Sets (and replaces) the model of memory leaks to be shown.
       * This function informs all children about then changed model.
       *
       * @param model a model containing the memory leaks and the suppression
       */
      void setModel( KMtraceModel *model );

      /**
       * Sets (and replaces) the model of memory leaks to be shown based
       * on a ktreefile to read.
       *
       * @param filename a ktreefile containing the model
       */
      void setModelFromFilename( const char *filename );

   protected slots:
      void slotEditToolbars( );
      void slotUpdateToolbars( );
      void slotShowSuppressed( );
      void slotSuppressListDialog( );
      void slotSuppressListDialogDone( );
      void slotOpenFile( );
      void slotOpenRecentFile( const KURL& url );
      virtual bool queryExit( );
      virtual void restoreSettings( KConfig *config );
      virtual void saveSettings( KConfig *config );
      
   public slots:
      /**
       * Tells the main window to show a new status line.
		 * Normally connected to the signal
       * @ref KMtraceLeaksView::moduleChanged which gets called when the
       * user changes the focus in the list of modules. See also slot
       * @ref slotModuleUnselect.
       *
       * @param module the filename of file containig the source code
       *        of the leaking code
       * @param line set the focus to this line
       */
      void slotModuleChanged( QString module, int line );
      
      /**
       * Tells the main window to show a new statis line saying there is
		 * no source code (because none is available either in a library call
		 * or when having the list view focus not within the function call stack).
       */
      void slotModuleUnselect( );

   private:
      // the model for the output of the kmtrace command
      KMtraceModel *m_model;
       
      // the two main widgets (statistics and list of leaks)
      KMtraceStatisticsView *m_statsView;
      KMtraceLeaksView *m_leaksView;
      
      // the window showing the source code
      KMtraceSourceCodeView *m_sourceCodeView;
      
      // status bar
      KStatusBar *m_statusBar;

      // the "show supress list dialog"
      KToggleAction *m_showSuppressListDialog;

      // the "show suppressed" menu checker
      KToggleAction *m_showSuppressedAction;
      
      // the dialog contain all suppressions
      KMtraceSuppressListDialog *m_suppressListDialog;
      
      // the separator between source code and the list of leaks
      QSplitter *m_splitter;
};

#endif
