// Qt includes
#include <qobject.h>
#include <qstring.h>

// kmtraceviewer includes
#include "KMtraceLeak.hh"
#include "KMtraceLeak.moc"
#include "KMtraceCall.hh"


KMtraceLeak::KMtraceLeak( )
  : QObject( )
{
}

KMtraceLeak::KMtraceLeak( int bytes, int blocks, int firstBytes, QString firstAddress)
  : QObject( )
{
   m_blocks = blocks;
   m_bytes = bytes;
   m_firstBytes = firstBytes;
   m_firstAddress = firstAddress;
   m_suppressed = FALSE;
}

int KMtraceLeak::getBlocks( )
{
   return m_blocks;
}

int KMtraceLeak::getBytes( )
{
   return m_bytes;
}

int KMtraceLeak::getFirstBytes( )
{
   return m_firstBytes;
}

QString KMtraceLeak::getFirstAddress( )
{
   return m_firstAddress;
}

void KMtraceLeak::addCall( KMtraceCall *call )
{
   m_callStack.append( call );
}

KMtraceCallStack *KMtraceLeak::getCallStack( )
{
   return &m_callStack;
}

void KMtraceLeak::setSuppressed( bool suppressed )
{
   if( m_suppressed != suppressed ) {
      m_suppressed = suppressed;
      emit suppressionChanged( this );
   }
}

bool KMtraceLeak::isSuppressed( )
{
   return m_suppressed;
}

void KMtraceLeak::setView( KMtraceLeaksViewItem *kitem )
{
   m_kitem = kitem;
}

KMtraceLeaksViewItem *KMtraceLeak::getView( )
{
   return m_kitem;
}
