// -*- c++ -*-

/*
 *  Copyright (C) 2003, Ian Reinhart Geiser <geiseri@kde.org>
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this library; see the file COPYING.LIB.  If not, write to
 *  the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 *  Boston, MA 02111-1307, USA.
 */

#ifndef KJSEMBED_CONFIG_IMP_H
#define KJSEMBED_CONFIG_IMP_H

#include <qdatetime.h>
#include <qfont.h>
#include <qvariant.h>
#include <qpoint.h>
#include <qrect.h>
#include <qsize.h>
#include <qcolor.h>
#include <qstringlist.h>

#include "bindingobject.h"
class KConfig;

namespace KJSEmbed {
namespace Bindings {

class Config : public BindingObject
{
    Q_OBJECT
    Q_PROPERTY( bool forceGlobal READ forceGlobal WRITE setForceGlobal )
    Q_PROPERTY( bool dollarExpansion READ isDollarExpansion WRITE setDollarExpansion )
    Q_PROPERTY( bool readOnly READ isReadOnly WRITE setReadOnly )
    Q_PROPERTY( bool readDefaults READ readDefaults WRITE setReadDefaults )

public:
    Config( QObject *parent=0, const char *name=0);
    Config( QObject *parent, const char *name,  const QString& confName );
    virtual ~Config();

    void setForceGlobal( bool force );
    bool forceGlobal() const;
    void setDollarExpansion( bool _bExpand = true );
    bool isDollarExpansion() const;
    void setReadOnly(bool _ro);
    bool isReadOnly() const;
    void setReadDefaults(bool b);
    bool readDefaults() const;

public slots:
    KConfig *kconfig();

    // Group
    void setDesktopGroup();
    void setGroup(const QString&);
    QString group();
    QStringList groupList();
    QString locale();

    void rollback( bool bDeep = true );
    void sync();
    bool hasKey( const QString& key ) const;
    bool entryIsImmutable(const QString &key) const;
    void revertToDefault(const QString &key);
    bool hasDefault(const QString &key) const;

    void setFileWriteMode(int mode);
    QString readEntry(const QString& pKey, const QString& aDefault = QString::null ) const;
    QVariant readPropertyEntry( const QString& pKey, const QVariant &var) const;
    QStringList readListEntry( const QString& pKey, char sep ) const;
    QString readPathEntry( const QString& pKey, const QString & aDefault = QString::null ) const;
    QStringList readPathListEntry( const QString& pKey, char sep  ) const;
    int readNumEntry( const QString& pKey, int nDefault = 0 ) const;
    uint readUnsignedNumEntry( const QString& pKey, uint nDefault = 0 ) const;
    long readLongNumEntry( const QString& pKey, long nDefault = 0 ) const;
    double readDoubleNumEntry( const QString& pKey, double nDefault = 0.0 ) const;
    QFont readFontEntry( const QString& pKey, const QFont* pDefault = 0L ) const;
    bool readBoolEntry( const QString& pKey, const bool bDefault = false ) const;
    QRect readRectEntry( const QString& pKey, const QRect* pDefault = 0L ) const;
    QPoint readPointEntry( const QString& pKey, const QPoint* pDefault = 0L ) const;
    QSize readSizeEntry( const QString& pKey, const QSize* pDefault = 0L ) const;
    QColor readColorEntry( const QString& pKey, const QColor* pDefault = 0L ) const;
    QDateTime readDateTimeEntry( const QString& pKey, const QDateTime* pDefault = 0L ) const;
    QString readEntryUntranslated( const QString& pKey, const QString& aDefault = QString::null ) const;

    void writeEntry( const QString& pKey, const QString& pValue, bool bPersistent = true, bool bGlobal = false, bool bNLS = false );
    void writeEntry( const QString& pKey, const QVariant& pValue, bool bPersistent = true, bool bGlobal = false, bool bNLS = false );
    void writeEntry( const QString& pKey, const QStringList &rValue, char sep , bool bPersistent = true, bool bGlobal = false, bool bNLS = false );
    //void writeEntry( const QString& pKey, const QStringList& pValue, bool bPersistent = true, bool bGlobal = false, bool bNLS = false );
    void writeEntry( const QString& pKey, int nValue, bool bPersistent = true, bool bGlobal = false, bool bNLS = false );
    void writeEntry( const QString& pKey, uint nValue, bool bPersistent = true, bool bGlobal = false, bool bNLS = false );
    void writeEntry( const QString& pKey, unsigned long nValue, bool bPersistent = true, bool bGlobal = false, bool bNLS = false );
    void writeEntry( const QString& pKey, double nValue, bool bPersistent = true, bool bGlobal = false, char format = 'g', int precision = 6,bool bNLS = false );
    void writeEntry( const QString& pKey, bool bValue, bool bPersistent = true, bool bGlobal = false, bool bNLS = false );
    void writeEntry( const QString& pKey, const QFont& rFont, bool bPersistent = true, bool bGlobal = false, bool bNLS = false );
    void writeEntry( const QString& pKey, const QColor& rColor, bool bPersistent = true, bool bGlobal = false, bool bNLS = false );
    void writeEntry( const QString& pKey, const QDateTime& rDateTime,bool bPersistent = true, bool bGlobal = false,  bool bNLS = false );
    void writeEntry( const QString& pKey, const QRect& rValue, bool bPersistent = true, bool bGlobal = false, bool bNLS = false );
    void writeEntry( const QString& pKey, const QPoint& rValue, bool bPersistent = true, bool bGlobal = false, bool bNLS = false );
    void writeEntry( const QString& pKey, const QSize& rValue, bool bPersistent = true, bool bGlobal = false, bool bNLS = false );
    void writePathEntry( const QString& pKey, const QString & path, bool bPersistent = true, bool bGlobal = false, bool bNLS = false );
    void writePathEntry( const QString& pKey, const QStringList &rValue, char sep, bool bPersistent = true, bool bGlobal = false, bool bNLS = false );
    void deleteEntry( const QString& pKey, bool bNLS = false, bool bGlobal = false);
    bool deleteGroup( const QString& group, bool bDeep = true, bool bGlobal = false );

private:
    KConfig *m_config;
};
}
}

#endif
