/***************************************************************************
                          ktransactionwidget.h  -  description
                             -------------------
    begin                : Sat Sep 7 2002
    copyright            : (C) 2002 by Richard Garand
    email                : richard@garandnet.net
    $Id: ktransactionwidget.h,v 1.4 2002/09/10 01:02:50 richard Exp $
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KTRANSACTIONWIDGET_H
#define KTRANSACTIONWIDGET_H

#include <qwidget.h>
#include <qvbox.h>

class KBudgetDoc;
class QDate;
class KListView;
class KTransactionListItem;
class QPoint;

/**The main widget for the KTransactionWindow window.
  *@author Richard Garand
  */

class KTransactionWidget : public QVBox  {
  Q_OBJECT
  public: 
    KTransactionWidget(KBudgetDoc* doc, int account=-1, QWidget *parent=0, const char *name=0);
    ~KTransactionWidget();

    void selectMonth(QDate month);
    void selectAll();

    /** returns the id of the currently selected transaction or -1 */
    int getCurrent();

  signals:
    void contextMenuRequested(const QPoint& p);
    void transactionFuncsEnabled(bool enabled);
        
  public slots:
    void slotDeleteTransaction();
    void slotAccountChanged(int id);
    void slotContextMenuRequested(QListViewItem*, const QPoint &p, int);
    void slotSelectionChanged();
    void slotTransactionRename();
    
  private:
    void select(int year, int month);
  
    KBudgetDoc* m_doc;
    int m_account;
    KListView* list;
    KTransactionListItem* total;
    int m_sMonth, m_sYear;
};

#endif
