/***************************************************************************
                          klocalizer.cpp  -  description
                             -------------------
    begin                : Sun Sep 1 2002
    copyright            : (C) 2002 by Richard Garand
    email                : richard@garandnet.net
    $Id: klocalizer.cpp,v 1.2 2002/09/08 16:14:06 richard Exp $
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <klocale.h>
#include <kglobal.h>
 
#include "klocalizer.h"

KLocalizer l10n;

KLocalizer::KLocalizer()
  : m_locale(KGlobal::locale())
{
}

KLocalizer::~KLocalizer()
{
}

QString KLocalizer::formatMoney(float value)
{
  if ( !m_locale )
    m_locale = KGlobal::locale();

  if ( m_locale )
    return m_locale->formatMoney(value);

  QString ret;
  bool negative = value < 0;
  if ( value < -0.005f )
    value *= -1;
  if ( value < 0.005f )
    value = 0;
  ret.sprintf("$%.2f", value);
  if ( negative )
    ret.prepend('-');
  return ret;
}

KLocale* KLocalizer::locale()
{
  return m_locale;
}
