/***************************************************************************
                          knewtransaction.cpp  -  description
                             -------------------
    begin                : Fri Aug 30 2002
    copyright            : (C) 2002 by Richard Garand
    email                : richard@garandnet.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <klocale.h>
#include <qlayout.h>
#include <qlabel.h>
#include <kmessagebox.h>

#include "knewtransaction.h"
#include "kbudget.h"
#include "kbudgetdoc.h"

KNewTransaction::KNewTransaction(KBudgetApp* parent)
  : KDialogBase(parent, "knewtransaction", false, i18n("New Transaction"), Ok|Cancel), mainWin(parent)
{
  QWidget* page = new QWidget(this);
  setMainWidget(page);
  QGridLayout* grid = new QGridLayout(page);

  QLabel* lb = new QLabel(i18n("Date:"), page);
  grid->addWidget(lb, 0, 0);
  date = new KDateEdit(page);
  grid->addWidget(date, 0, 1);

  lb = new QLabel(i18n("From:"), page);
  grid->addWidget(lb, 1, 0);
  from = new KComboBox(page);
  grid->addWidget(from, 1, 1);

  lb = new QLabel(i18n("To:"), page);
  grid->addWidget(lb, 2, 0);
  to = new KComboBox(page);
  grid->addWidget(to, 2, 1);

  lb = new QLabel(i18n("Amount:"), page);
  grid->addWidget(lb, 3, 0);
  value = new KDoubleNumInput(page);
  value->setPrecision(2);
  grid->addWidget(value, 3, 1);

  lb = new QLabel(i18n("Description:"), page);
  grid->addWidget(lb, 4, 0);
  description = new KLineEdit(page);
  grid->addWidget(description, 4, 1);

  KBudgetDoc* doc = parent->getDocument();
  accounts = doc->getAllAccounts();
  for ( unsigned int i = 0; i < accounts.size(); i++ ) {
    from->insertItem(accounts[i].name());
    to->insertItem(accounts[i].name());
  }
}

KNewTransaction::~KNewTransaction()
{
}

void KNewTransaction::slotOk()
{
  QDate when = date->getDate();
  int fromAcct = accounts[from->currentItem()].id();
  int toAcct = accounts[to->currentItem()].id();
  float amount = value->value();
  QString desc = description->text();

  if ( !desc.stripWhiteSpace().length() )
    desc = "-";

  // TODO: check this before making the dialog!
  if ( !accounts.size() )
    KMessageBox::sorry(0, i18n("You can't enter a transaction when you have no accounts!"));
  else if ( fromAcct == toAcct )
    KMessageBox::sorry(0, i18n("The from account and to account must be different."));
  else {
    KBudgetDoc* doc = mainWin->getDocument();
    doc->newTransaction(fromAcct, toAcct, amount, when, desc);
    KDialogBase::slotOk();
  }
}
