/***************************************************************************
                          account.cpp  -  description
                             -------------------
    begin                : Sat Aug 10 2002
    copyright            : (C) 2002 by Richard Garand
    email                : richard@garandnet.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "account.h"
#include "kbudgetdoc.h"

Account::Account()
  : initialBalance(0)
{

}

Account::Account(KBudgetDoc* d, int i, types t, QString n, float ib) {
  m_type = t;
  m_name = n;
  initialBalance = ib;
  m_doc = d;
  m_id = i;
  dump();
}

Account::Account(const Account& from) {
  m_type = from.m_type;
  m_name = from.m_name;
  months = from.months;
  initialBalance = from.initialBalance;
  m_doc = from.m_doc;
  m_id = from.m_id;
}

Account::~Account() {

}

int Account::id() const
{
  return m_id;
}

void Account::setType(types tp)
{
	m_type = tp;
}

Account::types Account::type() const
{
	return m_type;
}

void Account::setName(QString n)
{
	m_name = n;
}

QString Account::name() const
{
	return m_name;
}

void Account::addTransaction(int id)
{
  Transaction &tr = m_doc->getTransaction(id);
  QDate date = tr.date();

  QMap<int,year_t>::iterator year;
  year_t::iterator month;
  createMonth(date.year(), date.month(), year, month);
  Month& mnth = months[date.year()][date.month()];

  mnth.transactions.push_back(id);
  float add = tr.value(); // TODO: \n // if it's from, we want to subtract, not add
  add *= m_id == tr.to() ? 1 : m_id == tr.from() ? -1 : 0;
//  add *= m_type == AC_INCOME ? 1 : 1;
  // TODO: clean this up
  float original = mnth.endBalance;
  float sum = original + add;
  mnth.endBalance = sum;

  float budgetChange = add;//tr.value();
//  budgetChange *= m_type == AC_INCOME ? 1 : m_type == AC_EXPENSE ? -1 : 0;
  budgetChange *= m_type == AC_EXPENSE ? -1 : 1;
  mnth.endBudget += budgetChange;

  month++;
  while ( year != months.end() ) {
    while ( month != (*year).end() ) {
      (*month).startBalance += add;
      (*month).endBalance += add;
      (*month).startBudget += budgetChange;
      (*month).endBudget += budgetChange;
    }
    year++;
    if ( year != months.end() )
      month = (*year).begin();
  }

  m_doc->signalAcctChanged(id);
}

void Account::removeTransaction(int id)
{
  Transaction &tr = m_doc->getTransaction(id);
  months[tr.date().year()][tr.date().month()].transactions.remove(id);
  // TODO: update balances
  if ( months[tr.date().year()][tr.date().month()].transactions.size() == 0 ) {
    months[tr.date().year()].remove(tr.date().month());
    if ( months[tr.date().year()].keys().size() == 0 )
      months.remove(tr.date().year());
  }
  m_doc->signalAcctChanged(id);
}

QValueList<int> Account::getTransactions(int year, int month) const
{
  return QValueList<int>();
}

QValueList<int> Account::getTransactions(QDate start, QDate end) const
{
  return QValueList<int>();
}

float Account::getBalance() const
{
  if ( months.size() )
    return (*--(*--months.end()).end()).endBalance;
  else
    return initialBalance;
}

float Account::startingBalance() const
{
  return initialBalance;
}

void Account::setStartingBalance(float balance)
{
  float diff = balance - initialBalance;
  initialBalance = balance;
  for ( QMap<int,year_t>::iterator yr = months.begin(); yr != months.end(); yr++ ) {
    for ( year_t::iterator month = (*yr).begin(); month != (*yr).end(); month++ ) {
      (*month).startBalance += diff;
      (*month).endBalance += diff;
    }
  }
}

float Account::change() const
{
  if ( m_type == AC_INCOME )
    return initialBalance - getBalance();
  else
    return getBalance(); - initialBalance;
}

float Account::startingBudget() const
{
  if ( months.size() )
    return (*(*months.begin()).begin()).startBudget;
  else
    return 0;
}

float Account::budget() const
{
  if ( months.size() )
    return (*--(*--months.end()).end()).endBudget;
  else
    return 0;
}
#include <stdio.h>
Account Account::clone(QDate fromDate, QDate toDate) const
{
  Account newAcct = *this;
  newAcct.months.clear();
  
  QMap<int,year_t>::const_iterator year = months.begin();
  year_t::const_iterator month = (*year).begin();
  bool firstMonth = true;

  while ( year != months.end() ) {
    while ( month != (*year).end() ) {
      if ( isInRange(fromDate, toDate, QDate(year.key(), month.key(), 1)) ) {
        if ( firstMonth ) {
          newAcct.initialBalance = (*month).startBalance;
          firstMonth = false;
        }
        newAcct.months[year.key()][month.key()].startBalance = (*month).startBalance;
        newAcct.months[year.key()][month.key()].endBalance = (*month).endBalance;
        newAcct.months[year.key()][month.key()].transactions = (*month).transactions;
        newAcct.months[year.key()][month.key()].startBudget = (*month).startBudget;
        printf("%i:%i set to %0.2f::%0.2f\n", year.key(), month.key(), (*month).startBudget, (*month).endBudget);
        newAcct.months[year.key()][month.key()].endBudget = (*month).endBudget;
      }
      month++;
    }
    year++;
  }

  // no months were added to the clone, so we need to set the initial balance
  const Month* m = monthBefore(fromDate);
  if ( firstMonth )
    if ( m ) {
      newAcct.initialBalance = m->endBalance;
      newAcct.months[fromDate.year()][fromDate.month()].startBudget = m->endBudget;
      newAcct.months[fromDate.year()][fromDate.month()].endBudget = m->endBudget;
      newAcct.months[fromDate.year()][fromDate.month()].startBalance = newAcct.initialBalance;
      newAcct.months[fromDate.year()][fromDate.month()].endBalance = newAcct.initialBalance;
    } else
      newAcct.initialBalance = 0;

  return newAcct;
}

const Account::Month* Account::monthBefore(QDate date) const
{
  QMap<int,year_t>::const_iterator year = months.begin();
  year_t::const_iterator month = (*year).begin();
  year_t::const_iterator prevmonth;
  if ( months.size() ) {
    QDate firstMonth(months.begin().key(), (*months.begin()).begin().key(), 1);
    if ( firstMonth < date ) {
      year = months.begin();
      while ( year != months.end() ) {
        month = (*year).begin();
        while ( month != (*year).end() ) {
          if ( year.key() > date.year() || (year.key() == date.year() && month.key() > date.month()) )
            return &*prevmonth;
          else {
            prevmonth = month;
            month++;
          } // end of test
        } // end of month iterator
        year++;
      } // end of year iterator
      return &*--month;
    } // end of have previous month
  } // end of have months
  return 0;
}

bool Account::isInRange(QDate from, QDate to, QDate test) const
{
  if ( to.isValid() ) {
    if ( test.year() < from.year() || test.year() > to.year() )
      return false;
    if ( from.month() && test.year() == from.year() && test.month() < from.month() )
      return false;
    if ( to.month() && test.year() == to.year() && test.month() > to.month() )
      return false;
    return true;
  }
  if ( test.year() != from.year() )
    return false;
  if ( from.month() && test.month() != from.month() )
    return false;
  return true;
}

void Account::createMonth(int year, int month, QMap<int,year_t>::iterator &yearIt, year_t::iterator &monthIt)
{
  // if the year doesn't exist, create it and the month
  if ( months.find(year) == months.end() ) {
    months[year][month].startBalance = initialBalance;
    months[year][month].endBalance = initialBalance;
    // if the new year isn't the first in the list...
    yearIt = months.find(year);
    monthIt = (*yearIt).find(month);
    if ( yearIt != months.begin() ) {
      yearIt--;
      monthIt = (*yearIt).end();
      months[month][year].startBalance = (*monthIt).endBalance;
      months[month][year].endBalance = (*monthIt).endBalance;
    }
  } else if ( months[year].find(month) == months[year].end() ) {
    // the year exists but the month doesn't
    months[year][month].startBalance = 0;
    yearIt = months.find(year);
    monthIt = (*yearIt).find(month);
    if ( monthIt != (*yearIt).begin() )
      monthIt--;
    else { // assuming there are no empty years
      yearIt--;
      monthIt = --(*yearIt).end();
    }
    months[year][month].startBalance = (*monthIt).endBalance;
    months[year][month].endBalance = (*monthIt).endBalance;
  }

  yearIt = months.find(year);
  monthIt = (*yearIt).find(month);
}

void Account::dump() const
{
//  printf( "Account %i: %0.2f to %0.2f\n", m_id, initialBalance, getBalance());
}
