/***************************************************************************
                          ktransfer.h  -  description
                             -------------------
    begin                : Sat Aug 25 2001
    copyright            : (C) 2001 by Jonathon Sim
    email                : jonathonsim@iname.com
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KTRANSFER_H
#define KTRANSFER_H

#include <qobject.h>
#include "ksynkconnection.h"

/**A base class for all transfer protocols
 *@author Jonathon Sim
 */

class KTransfer : public QObject  {
    Q_OBJECT

public:
    KTransfer(const KSynkConnection & connection);
    ~KTransfer();
    /** Self explanatory really.   */
    virtual  void transfer();
    /** Starts finding a listing of all directories matching the current connections filter. */
    virtual void startListing();

    virtual void setConnection( const KSynkConnection& _newVal);

    virtual const KSynkConnection& getConnection();

    /** Kills any currently active transfer.   */
    virtual void kill();

protected:
    /** The connection this transfer is associated with. */
    KSynkConnection * Connection;

signals:
    /** emitted to notify clients of the current completed percentage of the transfer */
    void signalPercent(unsigned long percent, unsigned long filesLeft);

    /** Emitted when transfer complete */
    void signalComplete();

    /** Used to provide user feedback in a label etc */
    void signalMessage(const QString & message);
};

#endif
