/*
 *
 * Copyright (C) 2003 George Staikos <staikos@kde.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this library; see the file COPYING.LIB.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */


#include "kdetvchannelplugin.h"
#include "channelstore.h"

#include <qfile.h>

#include <kdebug.h>
#include <kparts/componentfactory.h>


KdetvChannelPlugin::KdetvChannelPlugin(Kdetv *ktv, const QString& cfgkey, QObject *o, const char* n)
    : KdetvPluginBase(ktv, cfgkey, o, n),
      _flags(FormatReadWrite)
{
}


KdetvChannelPlugin::~KdetvChannelPlugin()
{
}


bool KdetvChannelPlugin::canRead(const QString& fmt) const
{
	return (_flags & FormatRead) && (_fmtName == fmt);
}


bool KdetvChannelPlugin::canWrite(const QString& fmt) const
{
	return (_flags & FormatWrite) && (_fmtName == fmt);
}


bool KdetvChannelPlugin::handlesFile(const QString& filename, int rflags) const
{
	return ((_flags & rflags) == rflags) && filename.endsWith(_fmtName);
}


bool KdetvChannelPlugin::load(ChannelStore *store, const QString &filename, const QString& fmt)
{  
    // file is closed in QFile destructor
	QFile file(filename);
	if (!file.open(IO_ReadOnly)) {
	    return false;
	}

	if (!load(store, &file, fmt)) {
		kdDebug() << "KdetvChannelPlugin::load(...) sub-class load method failed" << endl;
		return false;
	}

	kdDebug() << "KdetvChannelPlugin::load(...) sub-class load ok" << endl;
	return true;
}


bool KdetvChannelPlugin::save(ChannelStore *store, const QString &filename, const QString& fmt)
{
    // file is closed in QFile destructor
	QFile file(filename);
	if (!file.open(IO_WriteOnly)) {
	    return false;
	}

	if (!save(store, &file, fmt)) {
		kdDebug() << "KdetvChannelPlugin::save(...) sub-class save method failed" << endl;
		return false;
	}

	kdDebug() << "KdetvChannelPlugin::save(...) sub-class save ok" << endl;
	return true;
}


KdetvChannelPlugin::ChannelFileMetaInfo KdetvChannelPlugin::getMetaInfo(const QString &filename, const QString& fmt)
{
	QFile file(filename);
	file.open(IO_ReadOnly);

	KdetvChannelPlugin::ChannelFileMetaInfo x = getMetaInfo(&file, fmt);

	file.close();
	return x;
}


KdetvChannelPlugin::ChannelFileMetaInfo KdetvChannelPlugin::getMetaInfo(QIODevice* /*file*/, const QString& /*fmt*/ )
{
	return KdetvChannelPlugin::ChannelFileMetaInfo();
}


bool KdetvChannelPlugin::load(ChannelStore *, QIODevice *, const QString&)
{
	return false;
}

bool KdetvChannelPlugin::save(ChannelStore *, QIODevice *, const QString&)
{
	return false;
}


#include "kdetvchannelplugin.moc"

