//////////////////////////////////////////////////////////////////////////////
//
//    KEXIFDIALOG.CPP
//
//    Copyright (C) 2002-2004 Renchi Raju <renchi at pooh.tam.uiuc.edu>
//                            Gilles Caulier <caulier dot gilles at free.fr>
//                            Ralf Hoelzer <kde at ralfhoelzer.com>
//
//    This program is free software; you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation; either version 2 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program; if not, write to the Free Software
//    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//
//////////////////////////////////////////////////////////////////////////////

// Qt includes.

#include <qtabwidget.h>
#include <qstring.h>
#include <qimage.h>
#include <qpixmap.h>
#include <qlabel.h>
#include <qlayout.h>
#include <qframe.h>
#include <qpushbutton.h>
#include <qcombobox.h>

// KDE includes.

#include <klocale.h>
#include <kpopupmenu.h>
#include <kapplication.h>
#include <kurl.h>
#include <kdebug.h>
#include <kaboutdata.h>
#include <khelpmenu.h>

// Local includes.

#include "kexifwidget.h"
#include "kexifdata.h"
#include "kexifdialog.h"


KExifDialog::KExifDialog(QWidget *parent, const char *name)
     : KDialogBase( Plain, i18n("EXIF Information"), Help|Close,
                    Close, parent, name, true )
{
    // About data and help button.
   
    // All bugs must be reported to Digikam account in bko.
    KAboutData* about = new KAboutData("digikam",
                                       I18N_NOOP("KExif"), 
                                       "0.2.1",  
                                       I18N_NOOP("An Exif data viewer"),
                                       KAboutData::License_GPL,
                                       "(c) 2003-2004, Digikam team", 
                                       0,
                                       "http://digikam.sourceforge.net");
    
    about->addAuthor("Renchi Raju", I18N_NOOP("Main developer"),
                     "renchi@pooh.tam.uiuc.edu");

    about->addAuthor("Gilles Caulier", I18N_NOOP("developer"),
                     "caulier dot gilles at free.fr");
    
    about->addAuthor("Ralf Hoelzer", I18N_NOOP("developer"),
                     "kde at ralfhoelzer.com");

    QPushButton* helpButton = actionButton( Help );
    KHelpMenu* helpMenu = new KHelpMenu(this, about, false);
    helpMenu->menu()->removeItemAt(0);
    helpMenu->menu()->insertItem(i18n("Digikam Handbook"), this,
                                 SLOT(slotHelp()), 0, -1, 0);
    helpButton->setPopup( helpMenu->menu() );

    // ------------------------------------------------------

    QVBoxLayout* vlay = new QVBoxLayout(plainPage(), 5, 5);    
    QHBoxLayout* hlay = new QHBoxLayout(vlay);

    // ------------------------------------------------------

    int margin = 5;
    m_thumbLabel = new QLabel(plainPage());
    m_thumbLabel->setFixedSize(128+margin,128+margin);
    m_thumbLabel->setMargin(margin);
    m_thumbLabel->setFrameStyle(QFrame::Raised|QFrame::StyledPanel);
    hlay->addWidget(m_thumbLabel);

    // ------------------------------------------------------

    QVBoxLayout* nameComboLay = new QVBoxLayout(hlay);
    nameComboLay->setSpacing(10);
    nameComboLay->setAlignment(Qt::AlignCenter);
        
    m_nameLabel  = new QLabel(plainPage());
    m_nameLabel->setAlignment(Qt::AlignCenter);
    nameComboLay->addWidget(m_nameLabel);

    QFrame* hline = new QFrame(plainPage());
    hline->setFrameStyle(QFrame::HLine|QFrame::Sunken);
    nameComboLay->addWidget(hline);
    
    QHBoxLayout* comboLay   = new QHBoxLayout(nameComboLay);
    QLabel* modeComboLabel  = new QLabel(i18n("Select Level of detail:"), plainPage());
    m_modeComboBox = new QComboBox(plainPage());
    comboLay->addWidget(modeComboLabel);
    comboLay->addWidget(m_modeComboBox);

    m_modeComboBox->insertItem(i18n("Simple"));
    m_modeComboBox->insertItem(i18n("Full"));
    connect(m_modeComboBox, SIGNAL(activated(int)),
            SLOT(slotModeChanged(int)));

    // ------------------------------------------------------
    
    m_exifWidget = new KExifWidget(plainPage());
    vlay->addWidget(m_exifWidget);
    
    // ------------------------------------------------------
    
    resize(500,500);
}

KExifDialog::~KExifDialog()
{
}

void KExifDialog::slotHelp()
{
    KApplication::kApplication()->invokeHelp("kexif.anchor", "digikam");       
}

bool KExifDialog::loadFile(const QString& filepath)
{
    if (!m_exifWidget->loadFile(filepath))
        return false;

    QString filename(KURL(filepath).filename());
    m_nameLabel->setText("<h2>" + filename + "</h2>");

    QImage thumbnail(m_exifWidget->exifData()->getThumbnail());
    if (!thumbnail.isNull())
    {
        thumbnail = thumbnail.smoothScale(128,128, QImage::ScaleMin);
        m_thumbLabel->setPixmap(thumbnail);
    }
    else
    {
        m_thumbLabel->setPixmap(QPixmap());
    }

    return true;
}

bool KExifDialog::loadData(const QString& filename, char *data, int size)
{
    if (!m_exifWidget->loadData(data, size))
        return false;

    m_nameLabel->setText("<h2>" + filename + "</h2>");

    QImage thumbnail(m_exifWidget->exifData()->getThumbnail());
    if (!thumbnail.isNull())
    {
        thumbnail = thumbnail.smoothScale(128,128, QImage::ScaleMin);
        m_thumbLabel->setPixmap(thumbnail);
    }
    else
    {
        m_thumbLabel->setPixmap(QPixmap());
    }

    return true;
}

void KExifDialog::slotModeChanged(int)
{
    if (m_modeComboBox->currentText() == i18n("Simple"))
        m_exifWidget->setMode(KExifWidget::SIMPLE);
    else
        m_exifWidget->setMode(KExifWidget::FULL);
}

#include "kexifdialog.moc"
