#!/bin/bash


#  Slackbuild script for libkexif
# Author: Mark Tucker
# Created: Jul 31, 2004
# Changes:
#        Jul 31, 2004 - initial creation
#        Oct 7, 2004 - updated for 20040919
#        Oct 24, 2004 - updated for ver. 0.1
#

#
#----------------------------------------------------------------------
umask 0022
#----------------------------------------
# Package variables
#----------------------------------------
source="libkexif-0.1.tar.bz2"
pkgname="libkexif"
pkgver="0.1"
release="1mht"
package="$pkgname-$pkgver-i486-$release.tgz"
echo Package: $package

#----------------------------------------
# setup path variables
#----------------------------------------
# where the source archive is located
srcdir=`pwd`/SRC
thisfile=`pwd`/`basename $0`
# get working directory
workdir=`dirname $0`
if [ "$workdir" == "." ]; then
    workdir=`pwd`/$pkgname
    if [ ! -d $workdir ]; then
	echo Creating working directory $workdir ...
	mkdir -p $workdir
    fi
    echo Working directory is $workdir
    cd $workdir
    echo Changed directory to  `pwd`
fi
builddir=$workdir/$pkgname-$pkgver


# unpack the source
echo Unpacking the source...
tar -xjf $srcdir/$source



cd $builddir

#----------------------------------------
# setup the build environment
#----------------------------------------
export CFLAGS="-O2 -march=i486 -mcpu=i686"
export CPPFLAGS="-O2 -march=i486 -mcpu=i686"
export CXXFLAGS=$CPPFLAGS

#----------------------------------------
# configure 
#----------------------------------------
echo Running configure...
./configure --prefix=/opt/kde \
    > $workdir/config.output 2>&1

if [ $? -ne 0 ]; then
    echo There was a problem with the build process.
    echo check the contents of $workdir/config.output
    echo Exiting...
    exit
fi

#----------------------------------------
# make
#----------------------------------------
echo Running make...
make > $workdir/make.output 2>&1
if [ $? -ne 0 ]; then
    echo There was a problem with the build process.
    echo check the contents of $workdir/make.output
    echo Exiting...
    exit
fi

#----------------------------------------
# Set target directory
#----------------------------------------
target=$workdir/target
if [ ! -d $target ]; then
    mkdir $target
fi

#----------------------------------------
# install
#----------------------------------------
echo Installing to $target ...
make install DESTDIR=$target > $workdir/install.output 2>&1


echo finishing install...


# create install dir
mkdir $target/install

#----------------------------------------
# create slack-desc file to install
#----------------------------------------
cat > $target/install/slack-desc << END
        |-----handy-ruler------------------------------------------------------|
$pkgname: $pkgname $pkgver
$pkgname:
$pkgname: Libkexif is a library for manipulating EXIF information embedded in
$pkgname: images. It currently supports viewing of all EXIF information via
$pkgname: libexif. It also supports the modification of a few attributes in a
$pkgname: save way that preserves all other EXIF information in the file.
$pkgname:
$pkgname:
$pkgname:
$pkgname:
$pkgname: Packaged by Mark Tucker for Slackware 10.0 / KDE 3.3.1
END

#----------------------------------------
# create documentation directory
#----------------------------------------
mkdir -p $target/usr/doc/$pkgname-$pkgver
cp $builddir/[A-Z]* $target/usr/doc/$pkgname-$pkgver/
chmod a+r $target/usr/doc/$pkgname-$pkgver/*
cp $thisfile $target/usr/doc/$pkgname-$pkgver/SlackPkg.sh

#----------------------------------------
# fix group on bin directories.
#----------------------------------------
for i in bin sbin usr/sbin usr/bin usr/X11R6/bin
do
  if [ -d $target/$i ]; then
      echo Changing group on $target/$i
      chgrp -R bin $target/$i
  fi
done

#----------------------------------------
# check for uncompressed man pages
#----------------------------------------
for i in usr/man opt/kde/man usr/share/man
do
  if [ -d $target/$i ]; then
      find $target/$i -name \*.[0-9] -exec gzip {} \;
  fi
done

# makepkg
cd $target
echo Creating package...
makepkg  -c n -l y $workdir/$package 

cd $workdir
echo DONE
exit

