/***************************************************************************
                          logbookwidget.cpp  -  description
                             -------------------
    begin                : Son Apr 7 2002
    copyright            : (C) 2002 by Martin Habbecke
    email                : M.Habbecke@gmx.de
    version              : $Revision: 1.5 $
    date                 : $Date: 2002/04/14 09:24:11 $
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <qstring.h>
#include <qdatetime.h>

#include <klistview.h>
#include <kaction.h>

#include "dive.h"
#include "logbook.h"
#include "logbookwidget.h"



LogBookWidget::LogBookListViewItem::LogBookListViewItem( const Dive &dive, KListView *parent )
    : KListViewItem( parent )
{
    _number = dive.number();


    QString txt;

    txt.sprintf( "%d", dive.number() );
    setText( 0, txt );
    
    txt.sprintf( "%s", dive.dateTime().date().toString( "dd.MM.yyyy" ).latin1() );
    setText( 1, txt );
    
    txt.sprintf( "%s", dive.dateTime().time().toString( "hh:mm" ).latin1() );
    setText( 2, txt );
    
    txt.sprintf( "%d min", dive.duration() );
    setText( 3, txt );
    
    txt.sprintf( "%d m", dive.depth() );
    setText( 4, txt );
    
    setText( 5, dive.place() );

    setText( 6, (dive.hasProfile() ? "yes" : "no") );
}


QString LogBookWidget::LogBookListViewItem::key( int column, bool ascending ) const
{
    QString retVal;

    if( column == 0 )
    {
	retVal.sprintf( "%03d", _number );
	return retVal;
    }
    else
    {
	return KListViewItem::key( column, ascending );
    }
}


/***********************************************************************************************
 ***********************************************************************************************/







LogBookWidget::LogBookWidget( QWidget *parent, const char *name ) 
    : LogBookWidgetGUI(parent,name)
{
    _listView->setAllColumnsShowFocus( true );
    _listView->setMultiSelection( true );

    connect( _listView, SIGNAL(selectionChanged()),
	     this, SLOT(slotSelectionChanged()) );
}



LogBookWidget::~LogBookWidget()
{
}



void LogBookWidget::setLogBook( LogBook *logBook )
{
    KListViewItem *item = 0;
    QString txt;

    _listView->clear();

    for( Dive *dive = logBook->first();
	 dive;
	 dive = logBook->next() )
    {
	item = new LogBookListViewItem( *dive, _listView );

    }
}



void LogBookWidget::getSelectedDives( QPtrList< int > &selectionList )
{
    selectionList.clear();

    for( LogBookListViewItem *item = (LogBookListViewItem *) _listView->firstChild();
	 item;
	 item = (LogBookListViewItem *) item->nextSibling() )
    {
	if( item->isSelected() )
	{
	    selectionList.append( new int( item->diveNumber() ) );
	}
    }
}



int LogBookWidget::getNumberOfSelectedDives( void )
{
    int number = 0;

    for( LogBookListViewItem *item = (LogBookListViewItem *) _listView->firstChild();
	 item;
	 item = (LogBookListViewItem *) item->nextSibling() )
    {
	if( item->isSelected() )
	{
	    number++;
	}
    }

    return number;
}



void LogBookWidget::slotSelectionChanged( void )
{
    emit( signalSelectionChanged( getNumberOfSelectedDives() ) );
}
