/***************************************************************************
                          logbook.cpp  -  description
                             -------------------
    begin                : Son Apr 7 2002
    copyright            : (C) 2002 by Martin Habbecke
    email                : M.Habbecke@gmx.de
    version              : $Revision: 1.4 $
    date                 : $Date: 2002/04/13 18:26:56 $
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <iostream.h>

#include "dive.h"
#include "logbook.h"



LogBook::LogBook()
    : QPtrList< Dive >()
{
    setAutoDelete( true );
}


LogBook::LogBook( const QString &name )
    : QPtrList< Dive >()
{
    _name = name;
    setAutoDelete( true );
}



LogBook::~LogBook()
{
    cout << "***** LogBook deleted:  \"" << _name << "\"" << endl;
}



void LogBook::deleteDive( int number )
{
    for( Dive *dive = first();
	 dive;
	 dive = next() )
    {
	if( dive->number() == number )
	{
	    remove( dive );
	}
    }
}


Dive const *LogBook::getDive( int number )
{
    for( Dive *dive = first();
	 dive;
	 dive = next() )
    {
	if( dive->number() == number )
	{
	    return dive;
	}
    }
    
    return 0L;
}


int LogBook::compareItems ( QPtrCollection::Item item1, QPtrCollection::Item item2 )
{
    cout << "compare!" << endl;

    Dive *dive1 = (Dive *) item1;
    Dive *dive2 = (Dive *) item2;

    if( dive1->dateTime() > dive2->dateTime() )
	return 1;
    else if( dive1->dateTime() < dive2->dateTime() )
	return -1;
    else
	return 0;
}
