// Emacs-Mode: -*-C++-*-
/***************************************************************************
                          interfacealadin.h  -  description
                             -------------------
    begin                : Son Apr 7 2002
    copyright            : (C) 2002 by Martin Habbecke
    email                : M.Habbecke@gmx.de
    version              : $Revision: 1.3 $
    date                 : $Date: 2002/04/12 17:07:47 $
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


#ifndef INTERFACEALADIN_H
#define INTERFACEALADIN_H


#include "interfacebase.h"
#include "dive.h"


// forward declarations
class QString;


//! Interface to Aladin Dive Computers
/*! Interface to Aladin Dive Computers

  \author Martin Habbecke
*/
class InterfaceAladin : public InterfaceBase {

    Q_OBJECT

public: 
    //! Default Constructor
    InterfaceAladin();

    //! Default Destructor
    virtual ~InterfaceAladin();

    //! Function to read datablock from Aladin Computer
    virtual retVal readData( const QString &device );


    //! Function to get the number of available dives
    virtual int getNumberOfDives( void );

    //! Function to get the i-th dive, 0 is the latest dive
    virtual bool getDive( int index, Dive &dive );



    //! Function to get the total number of progress-steps
    virtual int getProgressSteps( void );


public slots:
    //! Slot to stop reading data from Aladin Computer
    void slotStopReading( void );


signals:
    //! Signal that tells the progress of the readout
    void signalProgress( int progress );


protected:

    //! Function to "swap" all bits of a byte
    void swapBits( unsigned char *byte );

    //! Datablock from Aladin
    unsigned char _data[ 2050 ];

    //! Flag: keep on reading
    bool _keepReading;

};


#endif
