// Emacs-Mode: -*-C++-*-
/***************************************************************************
                          dive.h  -  description
                             -------------------
    begin                : Son Apr 7 2002
    copyright            : (C) 2002 by Martin Habbecke
    email                : M.Habbecke@gmx.de
    version              : $Revision: 1.4 $
    date                 : $Date: 2002/04/13 18:26:56 $
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef _DIVE_H_
#define _DIVE_H_


#include <qstring.h>
#include <qdatetime.h>

// forward declarations
class DiveProfile;


//! Data of one single dive
/*! Class to abstract one single dive.

  \author Martin Habbecke
*/
class Dive {

public: 
    //! Default Constructor
    Dive();

    //! Copy Constructor
    Dive( Dive const &rhs );

    //! Default Destructor
    ~Dive();

    //! Access to the number of the dive
    inline int number( void ) const;

    //! Access to the time and date of the dive
    inline QDateTime dateTime( void ) const;
    
    //! Access to the place of the dive
    inline QString place( void ) const;

    //! Access to the duration of the dive
    inline int duration( void ) const;

    //! Access to the depth of the dive
    inline int depth( void ) const;

    //! Access to the airconsumption of the dive
    inline int airConsumption( void ) const;

    //! Access to the water temperature of the dive
    inline int waterTemperature( void ) const;

    //! Access to the divebuddy
    inline QString buddy( void ) const;

    //! Access to the profile-data
    inline const DiveProfile *profile( void ) const;




    //! Function to set the number of the dive
    inline void setNumber( int number );

    //! Function to set the time and date of the dive
    inline void setDateTime( const QDateTime &dateTime );

    //! Function to set the place of the dive
    inline void setPlace( const QString &place );

    //! Function to set the duration of the dive
    inline void setDuration( int duration );

    //! Function to set the depth of the dive
    inline void setDepth( int depth );

    //! Function to set the airconsumption of the dive
    inline void setAirConsumption( int air );

    //! Function to set the water temperature of the dive
    inline void setWaterTemperature( int temp );

    //! Function to set the name of the divebuddy
    inline void setBuddy( const QString &buddy );



    
    //! Function to set profile-data obtained from an aladin computer
    void setAladinProfileData( unsigned char *data, int len );

    //! Function to ask, if the dive has profile-data
    bool hasProfile( void ) const;



protected:
    //! Number of the dive
    int _number;

    //! Date and Time of dive
    QDateTime _dateTime;

    //! Name of the place
    QString _place;

    //! Duration (in minutes) of the dive
    int _duration;

    //! Depth
    int _depth;

    //! Air consumption
    int _airConsumption;

    //! Water temperature
    int _waterTemperature;

    //! Dive-Buddy
    QString _buddy;

    //! Profile-Data
    DiveProfile *_profile;

};




inline int Dive::number( void ) const
{ return _number; }

inline QDateTime Dive::dateTime( void ) const
{ return _dateTime; }
    
inline QString Dive::place( void ) const
{ return _place; }

inline int Dive::duration( void ) const
{ return _duration; }

inline int Dive::depth( void ) const
{ return _depth; }

inline int Dive::airConsumption( void ) const
{ return _airConsumption; }

inline int Dive::waterTemperature( void ) const
{ return _waterTemperature; }

inline QString Dive::buddy( void ) const
{ return _buddy; }

inline const DiveProfile *Dive::profile( void ) const
{ return _profile; }



inline void Dive::setNumber( int number )
{ _number = number; }

inline void Dive::setDateTime( const QDateTime &dateTime )
{ _dateTime = dateTime; }

inline void Dive::setPlace( const QString &place )
{ _place = place; }

inline void Dive::setDuration( int duration )
{ _duration = duration; }

inline void Dive::setDepth( int depth )
{ _depth = depth; }

inline void Dive::setAirConsumption( int air )
{ _airConsumption = air; }

inline void Dive::setWaterTemperature( int temp )
{ _waterTemperature = temp; }

inline void Dive::setBuddy( const QString &buddy )
{ _buddy = buddy; }



#endif
