/*
 * Copyright (C) 2003 Ole Behrmann <obehrmann@hbg-bremen.de>
 * Copyright (C) 2003 Christoph Thielecke <crissi99@gmx.de>
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 */


#include "useradminadd.h"
#include "useradmin.h"
#include "currentuserinfo.h"
#include <qmessagebox.h>


//class for adding users
UserAdminAdd::UserAdminAdd(QString url_system_passwd_file, QString url_system_group_file) : UserAdminBaseAddUser() {

	setFixedSize ( QSize(width(),height())  ) ;

	 connect(btnOk, SIGNAL (clicked()),  this, SLOT (slotAddAll()));

    //mode for kurlrequester
    kurlHomeDir->setMode(KFile::Directory);

    //get values for user and group comboboxes

    //users
    QFile flGetSysUser(url_system_passwd_file);
    if ( flGetSysUser.open(IO_ReadOnly)) {
        QTextStream txtsGetSysUser( &flGetSysUser );
        QString readSysUser;


        while(!txtsGetSysUser.eof()) {
            readSysUser = txtsGetSysUser.readLine();

            int indexUid;

            indexUid = readSysUser.find(":");
            readSysUser.truncate(indexUid);

            cmbUid->insertItem(readSysUser, -1);

        }
        flGetSysUser.close();
    } else {
        // now using variable for path
        KMessageBox::sorry(this,i18n("Unable to open "+url_system_passwd_file+"!"));

    }

    //groups
    QFile flGetSysGrp(url_system_group_file);
    if ( flGetSysGrp.open(IO_ReadOnly)) {
        QTextStream txtsGetSysGrp( &flGetSysGrp );
        QString readSysGrp;


        while(!txtsGetSysGrp.eof()) {
            readSysGrp = txtsGetSysGrp.readLine();
            int indexGid;
            indexGid = readSysGrp.find(":");
            readSysGrp.truncate(indexGid);

            cmbGid->insertItem(readSysGrp, -1);
        }
        flGetSysGrp.close();
    } else {
        // now using variable for path
        KMessageBox::sorry(this,i18n("Unable to open "+url_system_group_file+"!"));

    }
    CurrentUserInfo userInfo;

    if (userInfo.getCurrentUser() != "root")
        cmbUid->setCompletedText(userInfo.getCurrentUser());
    else
        cmbUid->setCompletedText("ftp");

    if (userInfo.getCurrentGroup() != "root")
        cmbGid->setCompletedText(userInfo.getCurrentGroup());
    else
        cmbGid->setCompletedText("nogroup");


}

UserAdminAdd::~UserAdminAdd() {}

void UserAdminAdd::slotAddAll() {
    bool optionsOK=true;

    QString passwd,login, uid, gid, homeDir, fullName, downBand, upBand, maxFiles, maxSize;
    QString upRat, downRat, maxConn, frmTime, toTime, allCli, denCli, allLoc, denLoc;

    prcAdd = new QProcess(this);

    prcAdd->addArgument("pure-pw");
    prcAdd->addArgument("useradd");

    // #0 passwd
    QString pass1 = pssPass->password();
    QString pass2 = pssRe->password();
    if (pass1 == pass2) {
        passwd = pass1;
    } else {
        KMessageBox::sorry(this,i18n("Sorry passwords do not match!"));
        optionsOK=false;
    }


    // #1 login
    login = txtLogin->text();

    if (!login.isEmpty())
        prcAdd->addArgument(login);

    else {
        KMessageBox::sorry(this,i18n("Login is empty!"));
        optionsOK=false;
    }


    // #2 uid
    uid = cmbUid->currentText();
    if (uid != "root" && uid != "0") {
        prcAdd->addArgument("-u");
        prcAdd->addArgument(uid);
    } else {
        KMessageBox::sorry(this,i18n("UID is not allowed to be root!"));
        optionsOK=false;
    }

    // #3 gid
    gid = cmbGid->currentText();
    if (gid != "root" && gid != "0") {
        prcAdd->addArgument("-g");
        prcAdd->addArgument(gid);
    } else {
        KMessageBox::sorry(this,i18n("GID is not allowed to be root!"));
        optionsOK=false;
    }

    // #4 home dir
    homeDir = kurlHomeDir->url();
    if (homeDir.isEmpty())
        optionsOK=false;

    if (homeDir == "/")
        homeDir = "/.";
    if (rbYes->isChecked() == TRUE) {
        prcAdd->addArgument("-d");
        prcAdd->addArgument(homeDir);

    } else {
        prcAdd->addArgument("-D");
        prcAdd->addArgument(homeDir);
    }


    // #5 full name
    fullName = txtName->text();
    if (!fullName.isEmpty()) {
        prcAdd->addArgument("-c");
        prcAdd->addArgument(fullName);
    }

    // #6 Achtung Pfad korrekt setzen
    //prcAdd << "-f/etc/pureftpd.passwd";

    // #7 download bandwidth
    downBand = spnDown->text();
    if (checkDown->isChecked()) {
        prcAdd->addArgument("-t");
        prcAdd->addArgument(downBand);
    }

    // #8 upload bandwidth
    upBand = spnUp->text();
    if (checkUp->isChecked()) {
        prcAdd->addArgument("-T");
        prcAdd->addArgument(upBand);
    }

    // #9 max number of files
    maxFiles = spnFiles->text();
    if (checkFiles->isChecked()) {
        prcAdd->addArgument("-n");
        prcAdd->addArgument(maxFiles);
    }

    // #10 max size
    maxSize = spnSize->text();
    if (checkSize->isChecked()) {
        prcAdd->addArgument("-N");
        prcAdd->addArgument(maxSize);
    }

    // #11 upload ratio
    upRat = spnRatUp->text();
    if (chkRat->isChecked()) {
        prcAdd->addArgument("-q");
        prcAdd->addArgument(upRat);
    }

    // #12 download ratio
    downRat = spnRatDwn->text();
    if (chkRat->isChecked()) {
        prcAdd->addArgument("-Q");
        prcAdd->addArgument(downRat);
    }

    // #13 allow client host
    int lst1Count = lst1->count();
    int i1;
    for(i1 = 0; i1 < lst1Count; i1++) {
        allCli += lst1->text(i1)+",";
    }

    if (!allCli.isEmpty()) {
        allCli.truncate(allCli.length()-1);
        prcAdd->addArgument("-r");
        prcAdd->addArgument(allCli);
    }



    // #14 deny client host
    int lst2Count = lst2->count();
    int i2;
    for(i2 = 0; i2 < lst2Count; i2++) {
        denCli += lst2->text(i2)+",";
    }

    if (!denCli.isEmpty()) {
        denCli.truncate(denCli.length()-1);
        prcAdd->addArgument("-R"+denCli);
    }


    // #15 allow local host
    int lst3Count = lst3->count();
    int i3;
    for(i3 = 0; i3 < lst3Count; i3++) {
        allLoc += lst3->text(i3)+",";
    }

    if (!allLoc.isEmpty()) {
        allLoc.truncate(allLoc.length()-1);
        prcAdd->addArgument("-i"+allLoc);
        prcAdd->addArgument(allLoc);
    }

    // #16 deny local host
    int lst4Count = lst4->count();
    int i4;
    for(i4 = 0; i4 < lst4Count; i4++) {
        denLoc += lst4->text(i4)+",";
    }

    if (!denLoc.isEmpty()) {
        denLoc.truncate(denLoc.length()-1);
        prcAdd->addArgument("-I");
        prcAdd->addArgument(denLoc);
    }


    // #17 max number of concurrent sessions
    maxConn = spnConn->text();
    if (checkConn->isChecked()) {
        prcAdd->addArgument("-y");
        prcAdd->addArgument(maxConn);
    }

    // #18 time restrictions
    frmTime = spnTimeFrm->text();
    if (frmTime < 1000) {

        frmTime = "0"+frmTime;
    }

    toTime = spnTimeTo->text();
    if (toTime < 1000) {

        toTime = "0"+toTime;
    }

    if (chkTime->isChecked()) {
        prcAdd->addArgument("-z");
        prcAdd->addArgument(frmTime+"-"+toTime);
    }

    prcAdd->addArgument("-m");

    connect( prcAdd, SIGNAL(wroteStdin()), this, SLOT(closeStdin()));
    connect( prcAdd, SIGNAL(processExited()), this, SLOT(slotClosed()));

    if (optionsOK==true) {
        //start process
        if (!prcAdd->start()) {
            KMessageBox::sorry(this,i18n("Unable to start process!"));
        }
        prcAdd->writeToStdin(passwd+"\n");
        prcAdd->writeToStdin(passwd+"\n");

        this->close();
    }
}

void UserAdminAdd::slotAbort() {
    this->close();
}

void UserAdminAdd::slotClosed() {
    emit addDialogClosed();
}

void UserAdminAdd::slotEnBand() {
    if (!chkBand->isChecked()) {
      checkFiles->setEnabled(FALSE);
      checkConn->setEnabled(FALSE);
      checkUp->setEnabled(FALSE);
      checkDown->setEnabled(FALSE);
      checkSize->setEnabled(FALSE);

    } else {
      checkFiles->setEnabled(TRUE);
      checkConn->setEnabled(TRUE);
      checkUp->setEnabled(TRUE);
      checkDown->setEnabled(TRUE);
      checkSize->setEnabled(TRUE);

    }
}

void UserAdminAdd::slotEnAcc() {
    if (!chkAcc->isChecked()) {
        btnIPallow->setEnabled(FALSE);
        btnIPdeny->setEnabled(FALSE);
        btnIPallowLocal->setEnabled(FALSE);
        btnIPdenyLocal->setEnabled(FALSE);
    }
    else {
        btnIPallow->setEnabled(TRUE);
        btnIPdeny->setEnabled(TRUE);
        btnIPallowLocal->setEnabled(TRUE);
        btnIPdenyLocal->setEnabled(TRUE);
    }
}

void UserAdminAdd::slotEnTime() {
    if (!chkTime->isChecked()) {
        spnTimeFrm->setEnabled(FALSE);
        spnTimeTo->setEnabled(FALSE);
    } else {
        spnTimeFrm->setEnabled(TRUE);
        spnTimeTo->setEnabled(TRUE);
    }
}

void UserAdminAdd::slotEnRatio() {
    if (!chkRat->isChecked()) {
        spnRatUp->setEnabled(FALSE);
        spnRatDwn->setEnabled(FALSE);
    } else {
        spnRatUp->setEnabled(TRUE);
        spnRatDwn->setEnabled(TRUE);
    }
}

void  UserAdminAdd::slotCliIpAcc() {
    dialog1 = new KLineEditDlg(i18n("Enter allowed client ip"),"",this);
    connect(dialog1, SIGNAL (okClicked()), this, SLOT (slotCliIpAccAdd()));
    dialog1->exec();
}
void  UserAdminAdd::slotCliIpAccAdd() {
    lst1->insertItem(dialog1->text(),-1);
    btnIPallowRem->setEnabled(true);
}

void UserAdminAdd::slotCliIpAccRem()
{
int lst1Curr = lst1->currentItem();
	lst1->removeItem(lst1Curr);

if (lst1->count() == 0)
	btnIPallowRem->setEnabled(false);
}

void  UserAdminAdd::slotCliIpDen() {
    dialog2 = new KLineEditDlg(i18n("Enter denied client ip"),"",this);
    connect(dialog2, SIGNAL (okClicked()), this, SLOT (slotCliIpDenAdd()));
    dialog2->exec();
}
void  UserAdminAdd::slotCliIpDenAdd() {
    lst2->insertItem(dialog2->text(),-1);
    btnIPdenyRem->setEnabled(true);
}

void UserAdminAdd::slotCliIpDenRem()
{
int lst2Curr = lst2->currentItem();
	lst2->removeItem(lst2Curr);

if (lst2->count() == 0)
	btnIPdenyRem->setEnabled(false);
}

void  UserAdminAdd::slotLocIpAcc() {
    dialog3 = new KLineEditDlg(i18n("Enter allowed local ip"),"",this);
    connect(dialog3, SIGNAL (okClicked()), this, SLOT (slotLocIpAccAdd()));
    dialog3->exec();
}
void  UserAdminAdd::slotLocIpAccAdd() {
    lst3->insertItem(dialog3->text(),-1);
    btnIPallowLocalRem->setEnabled(true);
}

void UserAdminAdd::slotLocIpAccRem()
{
int lst3Curr = lst3->currentItem();
	lst3->removeItem(lst3Curr);

if (lst3->count() == 0)
	btnIPallowLocalRem->setEnabled(false);
}


void  UserAdminAdd::slotLocIpDen() {
    dialog4 = new KLineEditDlg(i18n("Enter denied local ip"),"",this);
    connect(dialog4, SIGNAL (okClicked()), this, SLOT (slotLocIpDenAdd()));
    dialog4->exec();
}
void  UserAdminAdd::slotLocIpDenAdd() {
    lst4->insertItem(dialog4->text(),-1);
    btnIPdenyLocalRem->setEnabled(true);
}

void UserAdminAdd::slotLocIpDenRem()
{
int lst4Curr = lst4->currentItem();
	lst4->removeItem(lst4Curr);

if (lst4->count() == 0)
	btnIPdenyLocalRem->setEnabled(false);
}

void UserAdminAdd::slotEnBandwFiles(){
   if (!checkFiles->isChecked()) {
        spnFiles->setEnabled(FALSE);
   }
   else {
        spnFiles->setEnabled(TRUE);
   }

}

void UserAdminAdd::slotEnBandwSize(){
   if (!checkSize->isChecked()) {
        spnSize->setEnabled(FALSE);
   }
   else {
        spnSize->setEnabled(TRUE);
   }

}

void UserAdminAdd::slotEnBandwUp(){
   if (!checkUp->isChecked()) {
        spnUp->setEnabled(FALSE);
   }
   else {
        spnUp->setEnabled(TRUE);
   }

}

void UserAdminAdd::slotEnBandwDown(){
   if (!checkDown->isChecked()) {
        spnDown->setEnabled(FALSE);
   }
   else {
        spnDown->setEnabled(TRUE);
   }

}

void UserAdminAdd::slotEnBandwConn(){
   if (!checkConn->isChecked()) {
        spnConn->setEnabled(FALSE);
   }
   else {
        spnConn->setEnabled(TRUE);
   }

}


