/*
 *   Copyright (C) 2003 Crissi <crissi99@gmx.de>
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 */

#include "kpum.h"
#include <kapplication.h>
#include <kaboutdata.h>
#include <kcmdlineargs.h>
#include <klocale.h>

static const char *description =
    I18N_NOOP("User Administration for the pureftpd server.");

static const char *version = "0.5.2";

static KCmdLineOptions options[] =    {
                                          { 0, 0, 0 }
                                      };

int main(int argc, char **argv) {
    KAboutData *aboutData = new KAboutData("kpum", I18N_NOOP("kpum"), version, description,
                                           KAboutData::License_GPL, "(C) 2003 Ole Behrmann, Christoph Thielecke", 0, 0, "obehrmann@hbg-bremen.de, crissi99@gmx.de");
    aboutData->addAuthor( "Ole Behrmann", 0, "obehrmann@hbg-bremen.de" );
    aboutData->addAuthor( "Christoph Thielecke", 0, "crissi99@gmx.de" );

    aboutData->addCredit("Ole Behrmann",I18N_NOOP("Core programmming"),"obehrmann@hbg-bremen.de");

    aboutData->addCredit("Christoph Thielecke",I18N_NOOP("Programmming and German translation"),
                         "crissi99@gmx.de");

    KCmdLineArgs::init(argc, argv, aboutData);
    KCmdLineArgs::addCmdLineOptions( options );
    KApplication app;
    KPum *mainWin = 0;

    if (app.isRestored()) {
        RESTORE(KPum);
    } else {

        KCmdLineArgs *args = KCmdLineArgs::parsedArgs();

        mainWin = new KPum();
        app.setMainWidget( mainWin );
        mainWin->show();

        args->clear();
    }

    return app.exec();
}
